/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.GraphBuilder;
import io.konig.core.NamespaceManager;
import io.konig.core.Transaction;
import io.konig.core.TransactionWorker;
import io.konig.core.Traversal;
import io.konig.core.UidGenerator;
import io.konig.core.Vertex;
import io.konig.core.impl.EdgeImpl;
import io.konig.core.impl.EdgeIterator;
import io.konig.core.impl.ResourceVertex;
import io.konig.core.impl.UidGeneratorImpl;
import io.konig.core.impl.VertexImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;

public class MemoryGraph
implements Graph,
Transaction {
    private static final UidGenerator uid = new UidGeneratorImpl();
    private ValueFactory valueFactory = new ValueFactoryImpl();
    private Resource id;
    private Map<String, Vertex> bnodeMap = new LinkedHashMap<String, Vertex>();
    private Map<Resource, Vertex> vertexMap = new LinkedHashMap<Resource, Vertex>();
    private List<Edge> txn;
    private List<Edge> sink;
    private Transaction.Status status = Transaction.Status.CLOSED;
    private List<TransactionWorker> workerList = new ArrayList<TransactionWorker>();
    private NamespaceManager nsManager;
    private boolean copyEdgeAttributes = false;

    public MemoryGraph() {
    }

    public MemoryGraph(Collection<Edge> source) {
        for (Edge e : source) {
            this.add(e);
        }
    }

    public MemoryGraph(NamespaceManager nsManager) {
        this.nsManager = nsManager;
    }

    public boolean isCopyEdgeAttributes() {
        return this.copyEdgeAttributes;
    }

    public void setCopyEdgeAttributes(boolean copyEdgeAttributes) {
        this.copyEdgeAttributes = copyEdgeAttributes;
    }

    @Override
    public Vertex vertex(Resource id) {
        ResourceVertex rv;
        Vertex v;
        if (id instanceof ResourceVertex && (v = (rv = (ResourceVertex)id).getVertex()).getGraph() == this) {
            return v;
        }
        BNode bnode = null;
        if (id instanceof BNode) {
            bnode = (BNode)id;
        }
        if (bnode != null) {
            v = this.bnodeMap.get(bnode.getID());
            if (v != null) {
                return v;
            }
            id = new BNodeImpl(uid.next());
        }
        if ((v = this.vertexMap.get(id)) == null) {
            v = new VertexImpl(this, id);
            this.vertexMap.put(id, v);
            if (bnode != null) {
                this.bnodeMap.put(bnode.getID(), v);
            }
        }
        return v;
    }

    @Override
    public Vertex getVertex(Resource id) {
        return this.vertexMap.get(id);
    }

    @Override
    public Vertex vertex(String id) {
        Resource node = this.createResource(id);
        return this.vertex(node);
    }

    private Resource createResource(String id) {
        return id.startsWith("_:") ? this.valueFactory.createBNode(id.substring(2)) : this.valueFactory.createURI(id);
    }

    @Override
    public Vertex getVertex(String id) {
        return this.getVertex(this.createResource(id));
    }

    private ResourceVertex wrap(Resource object) {
        Vertex objectVertex;
        if (object instanceof ResourceVertex) {
            ResourceVertex rv = (ResourceVertex)object;
            VertexImpl v = rv.getVertexImpl();
            if (v.getGraph() == this) {
                return rv;
            }
            object = v.getId();
        }
        if (object instanceof URI) {
            objectVertex = this.vertex(object);
            return (ResourceVertex)objectVertex.getId();
        }
        if (object instanceof BNode) {
            objectVertex = this.vertex((Resource)((BNode)object));
            return (ResourceVertex)objectVertex.getId();
        }
        return null;
    }

    @Override
    public Edge edge(Resource subject, URI predicate, Value object) {
        return this.edge(subject, predicate, object, null);
    }

    @Override
    public Edge edge(Resource subject, URI predicate, Value object, Resource context) {
        ResourceVertex s = this.wrap(subject);
        ResourceVertex o = null;
        if (object instanceof Resource) {
            o = this.wrap((Resource)object);
            object = o;
        }
        EdgeImpl e = new EdgeImpl(s, predicate, (Value)object, context);
        s.getVertexImpl().add(e);
        if (o != null) {
            o.getVertexImpl().add(e);
        }
        if (this.sink != null) {
            this.sink.add(e);
        }
        return e;
    }

    @Override
    public Edge edge(Vertex subject, URI predicate, Vertex object) {
        return this.edge(subject.getId(), predicate, (Value)object.getId());
    }

    @Override
    public Collection<Vertex> vertices() {
        return this.vertexMap.values();
    }

    @Override
    public Traversal v(Resource subject) {
        return this.vertex(subject).asTraversal();
    }

    @Override
    public Transaction tx() {
        return this;
    }

    @Override
    public void open() {
        this.sink = new ArrayList<Edge>();
        this.txn = this.sink;
        this.status = Transaction.Status.OPEN;
    }

    @Override
    public Transaction.Status getStatus() {
        return this.status;
    }

    @Override
    public void commit() {
        if (this.status != Transaction.Status.OPEN) {
            return;
        }
        this.status = Transaction.Status.VOTE;
        if (this.txn != null && !this.txn.isEmpty()) {
            this.sink = new ArrayList<Edge>();
            while (this.status == Transaction.Status.VOTE) {
                for (TransactionWorker worker : this.workerList) {
                    worker.commit(this);
                    if (this.status != Transaction.Status.ROLLBACK) continue;
                    break;
                }
                if (this.sink.isEmpty() && this.status == Transaction.Status.VOTE) {
                    this.status = Transaction.Status.COMMIT;
                    continue;
                }
                this.txn = this.sink;
                this.sink = new ArrayList<Edge>();
            }
        }
        this.bnodeMap = new LinkedHashMap<String, Vertex>();
    }

    @Override
    public void rollback() {
        this.status = Transaction.Status.ROLLBACK;
    }

    @Override
    public List<Edge> asList() {
        return this.txn;
    }

    @Override
    public void addWorker(TransactionWorker worker) {
        this.workerList.add(worker);
    }

    @Override
    public void removeWorker(TransactionWorker worker) {
        this.workerList.remove(worker);
    }

    @Override
    public Edge edge(Edge edge) {
        Edge result = this.edge(edge.getSubject(), edge.getPredicate(), edge.getObject(), edge.getContext());
        if (this.copyEdgeAttributes) {
            result.copyAnnotations(edge);
        }
        return result;
    }

    @Override
    public void remove(Edge edge) {
        Vertex subject = this.vertex(edge.getSubject());
        subject.remove(edge);
        if (edge.getObject() instanceof Resource) {
            Vertex object = this.vertex((Resource)edge.getObject());
            object.remove(edge);
        }
    }

    @Override
    public void add(Vertex vertex) {
        Set<Map.Entry<URI, Set<Edge>>> out = vertex.outEdges();
        for (Map.Entry<URI, Set<Edge>> e : out) {
            Set<Edge> set = e.getValue();
            for (Edge edge : set) {
                this.edge(edge);
                Value object = edge.getObject();
                if (!(object instanceof BNode)) continue;
                Vertex bnode = this.vertex((Resource)object);
                this.add(bnode);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Vertex v : this.vertices()) {
            Set<Edge> inSet;
            Resource id = v.getId();
            if (id instanceof BNode && !(inSet = v.inEdgeSet()).isEmpty()) continue;
            buffer.append(v.toString());
            Graph namedGraph = v.asNamedGraph();
            if (namedGraph == null) continue;
            buffer.append("BEGIN GRAPH\n");
            buffer.append(namedGraph.toString());
            buffer.append("END GRAPH\n");
        }
        return buffer.toString();
    }

    @Override
    public Resource getId() {
        return this.id;
    }

    @Override
    public void setId(Resource id) {
        this.id = id;
    }

    @Override
    public Vertex vertex() {
        BNodeImpl id = new BNodeImpl(uid.next());
        VertexImpl vertex = new VertexImpl(this, (Resource)id);
        id = (BNode)vertex.getId();
        this.bnodeMap.put(id.stringValue(), vertex);
        this.vertexMap.put((Resource)id, vertex);
        return vertex;
    }

    @Override
    public GraphBuilder builder() {
        return new GraphBuilder(this);
    }

    @Override
    public boolean add(Statement statement) {
        return this.add(new EdgeImpl(statement.getSubject(), statement.getPredicate(), statement.getObject()));
    }

    @Override
    public boolean add(Edge edge) {
        this.edge(edge);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Edge> sequence) {
        for (Edge edge : sequence) {
            this.edge(edge);
        }
        return true;
    }

    @Override
    public void clear() {
        this.bnodeMap = new LinkedHashMap<String, Vertex>();
        this.vertexMap = new LinkedHashMap<Resource, Vertex>();
        this.txn = null;
        this.sink = null;
        this.status = Transaction.Status.CLOSED;
    }

    @Override
    public boolean contains(Object obj) {
        Resource subject;
        Vertex subjectVertex;
        Edge edge = null;
        if (obj instanceof Edge) {
            edge = (Edge)obj;
        } else if (obj instanceof Statement) {
            Statement s = (Statement)obj;
            edge = new EdgeImpl(s.getSubject(), s.getPredicate(), s.getObject());
        }
        if (edge != null && (subjectVertex = this.getVertex(subject = edge.getSubject())) != null) {
            return subjectVertex.hasEdge(edge);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.vertexMap.isEmpty();
    }

    @Override
    public Iterator<Edge> iterator() {
        return new EdgeIterator(this);
    }

    @Override
    public boolean remove(Object obj) {
        if (obj instanceof Edge) {
            this.remove((Edge)obj);
        }
        if (obj instanceof Statement) {
            Statement s = (Statement)obj;
            this.remove(new EdgeImpl(s.getSubject(), s.getPredicate(), s.getObject()));
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        for (Object obj : collection) {
            this.remove(obj);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int count = 0;
        Iterator<Edge> sequence = this.iterator();
        while (sequence.hasNext()) {
            sequence.next();
            ++count;
        }
        return count;
    }

    @Override
    public Object[] toArray() {
        ArrayList<Edge> list = new ArrayList<Edge>();
        Iterator<Edge> sequence = this.iterator();
        while (sequence.hasNext()) {
            list.add(sequence.next());
        }
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamespaceManager getNamespaceManager() {
        return this.nsManager;
    }

    @Override
    public void setNamespaceManager(NamespaceManager nsManager) {
        this.nsManager = nsManager;
    }

    @Override
    public boolean contains(Resource subject, URI predicate, Value object) {
        EdgeImpl s = new EdgeImpl(subject, predicate, object);
        return this.contains(s);
    }

    @Override
    public void remove(Vertex v) {
        if (v == null) {
            return;
        }
        Resource id = v.getId();
        Graph g = v.getGraph();
        if (g != this) {
            v = this.getVertex(id);
            id = v.getId();
        }
        this.vertexMap.remove(id);
        Set<Map.Entry<URI, Set<Edge>>> inSet = v.inEdges();
        for (Map.Entry<URI, Set<Edge>> entry : inSet) {
            Iterator<Edge> iterator = entry.getValue().iterator();
            URI predicate = entry.getKey();
            while (iterator.hasNext()) {
                Edge edge = iterator.next();
                iterator.remove();
                Resource subjectId = edge.getSubject();
                Vertex subject = this.getVertex(subjectId);
                if (subject == null) continue;
                Set<Edge> set = subject.outProperty(predicate);
                set.remove(edge);
                edge = null;
            }
        }
        Set<Map.Entry<URI, Set<Edge>>> outSet = v.outEdges();
        for (Map.Entry<URI, Set<Edge>> entry : outSet) {
            Iterator<Edge> iterator = entry.getValue().iterator();
            URI predicate = entry.getKey();
            while (iterator.hasNext()) {
                Edge edge = iterator.next();
                Value value = edge.getObject();
                if (!(value instanceof Resource)) continue;
                iterator.remove();
                Resource objectId = (Resource)value;
                Vertex object = this.getVertex(objectId);
                if (object == null) continue;
                Set<Edge> set = object.inProperty(predicate);
                set.remove(edge);
                if (!object.isOrphan()) continue;
                this.remove(object);
            }
        }
    }

    @Override
    public void remove(Resource resource) {
        this.remove(this.getVertex(resource));
    }

    @Override
    public Set<URI> lookupLocalName(String localName) {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        for (Edge e : this) {
            this.matchLocalName(result, localName, (Value)e.getSubject());
            this.matchLocalName(result, localName, (Value)e.getPredicate());
            this.matchLocalName(result, localName, e.getObject());
        }
        return result;
    }

    private void matchLocalName(Set<URI> result, String localName, Value value) {
        URI uri;
        if (value instanceof URI && localName.equals((uri = (URI)value).getLocalName())) {
            result.add(uri);
        }
    }

    @Override
    public Edge edge(Resource subject, URI predicate, List<? extends Value> list) {
        Edge result = null;
        if (list != null) {
            Vertex prev = null;
            for (Value value : list) {
                Vertex next = this.vertex();
                if (prev == null) {
                    result = this.edge(subject, predicate, (Value)next.getId());
                } else {
                    this.edge(prev.getId(), RDF.REST, (Value)next.getId());
                }
                this.edge(next.getId(), RDF.FIRST, value);
                prev = next;
            }
            if (prev != null) {
                this.edge(prev.getId(), RDF.REST, (Value)RDF.NIL);
            }
        }
        return result;
    }

    @Override
    public Vertex mappedBNode(BNode bnode) {
        return this.bnodeMap.get(bnode.getID());
    }

    static class StatementIterator
    implements Iterator<Edge> {
        private Edge current;
        private Iterator<Vertex> vertexSequence;
        private Iterator<Map.Entry<URI, Set<Edge>>> predicateIterator;
        private Iterator<Edge> edgeSequence;

        public StatementIterator(Iterator<Vertex> vertexSequence) {
            this.vertexSequence = vertexSequence;
            this.lookAhead();
        }

        private void lookAhead() {
            this.current = null;
            if (this.edgeSequence != null) {
                if (this.edgeSequence.hasNext()) {
                    this.current = this.edgeSequence.next();
                    return;
                }
                this.edgeSequence = null;
            }
            if (this.predicateIterator != null) {
                while (this.predicateIterator.hasNext()) {
                    this.edgeSequence = this.predicateIterator.next().getValue().iterator();
                    if (this.edgeSequence.hasNext()) {
                        this.current = this.edgeSequence.next();
                        return;
                    }
                    this.edgeSequence = null;
                }
                this.predicateIterator = null;
            }
            while (this.vertexSequence.hasNext()) {
                Vertex v = this.vertexSequence.next();
                this.predicateIterator = v.outEdges().iterator();
                while (this.predicateIterator.hasNext()) {
                    this.edgeSequence = this.predicateIterator.next().getValue().iterator();
                    if (this.edgeSequence.hasNext()) {
                        this.current = this.edgeSequence.next();
                        return;
                    }
                    this.edgeSequence = null;
                }
                this.predicateIterator = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Edge next() {
            Edge result = this.current;
            this.lookAhead();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

