/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.NamespaceManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.Namespace;
import org.openrdf.model.impl.NamespaceImpl;

public class MemoryNamespaceManager
implements NamespaceManager {
    private static final MemoryNamespaceManager INSTANCE = new MemoryNamespaceManager();
    protected Map<String, Namespace> byPrefix = new HashMap<String, Namespace>();
    protected Map<String, Namespace> byName = new HashMap<String, Namespace>();

    public static MemoryNamespaceManager getDefaultInstance() {
        return INSTANCE;
    }

    public MemoryNamespaceManager() {
    }

    public MemoryNamespaceManager(NamespaceManager copy) {
        for (Namespace n : copy.listNamespaces()) {
            this.add(n);
        }
    }

    @Override
    public Namespace findByPrefix(String prefix) {
        return this.byPrefix.get(prefix);
    }

    @Override
    public Namespace findByName(String name) {
        return this.byName.get(name);
    }

    @Override
    public NamespaceManager add(Namespace ns) {
        this.byPrefix.put(ns.getPrefix(), ns);
        this.byName.put(ns.getName(), ns);
        return this;
    }

    @Override
    public NamespaceManager add(String prefix, String namespace) {
        return this.add((Namespace)new NamespaceImpl(prefix, namespace));
    }

    @Override
    public Collection<Namespace> listNamespaces() {
        return this.byPrefix.values();
    }

    static {
        INSTANCE.add("konig", "http://www.konig.io/ns/core/");
        INSTANCE.add("as", "http://www.w3.org/ns/activitystreams#");
        INSTANCE.add("sh", "http://www.w3.org/ns/shacl#");
        INSTANCE.add("prov", "http://www.w3.org/ns/prov#");
        INSTANCE.add("activity", "http://www.konig.io/activity/");
        INSTANCE.add("schema", "http://schema.org/");
        INSTANCE.add("xsd", "http://www.w3.org/2001/XMLSchema#");
        INSTANCE.add("dc", "http://purl.org/dc/terms/");
        INSTANCE.add("owl", "http://www.w3.org/2002/07/owl#");
        INSTANCE.add("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        INSTANCE.add("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
    }
}

