/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.Vertex;
import java.util.Iterator;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;

public class NaturalEdgeIterable
implements Iterable<Edge> {
    private Graph graph;

    public NaturalEdgeIterable(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Iterator<Edge> iterator() {
        return new TopIterator(this.graph);
    }

    static class BasicIterator
    implements Iterator<Edge> {
        Graph graph;
        Iterator<Edge> primary;
        BasicIterator secondary;
        Edge current = null;

        public BasicIterator(Graph graph, Iterator<Edge> primary) {
            this.graph = graph;
            this.primary = primary;
            this.current = primary.next();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Edge next() {
            Edge result = this.current;
            this.current = null;
            if (this.secondary != null) {
                this.current = this.secondary.next();
                if (!this.secondary.hasNext()) {
                    this.secondary = null;
                }
            }
            if (this.current == null) {
                Vertex node;
                Iterator<Edge> inner;
                if (result != null && result.getObject() instanceof BNode && (inner = (node = this.graph.getVertex((Resource)((BNode)result.getObject()))).outEdgeSet().iterator()).hasNext()) {
                    this.secondary = new BasicIterator(this.graph, inner);
                    this.current = this.secondary.next();
                    if (!this.secondary.hasNext()) {
                        this.secondary = null;
                    }
                }
                if (this.current == null && this.primary.hasNext()) {
                    this.current = this.primary.next();
                }
            }
            return result;
        }

        @Override
        public void remove() {
            throw new KonigException("remove method not supported");
        }
    }

    static class TopIterator
    implements Iterator<Edge> {
        private Graph graph;
        private Iterator<Vertex> vertexSequence;
        private Iterator<Edge> edgeSequence;
        private Edge current;

        public TopIterator(Graph graph) {
            this.graph = graph;
            this.vertexSequence = graph.vertices().iterator();
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Edge next() {
            Edge result = this.current;
            this.current = null;
            if (this.edgeSequence != null) {
                this.current = this.edgeSequence.next();
                if (!this.edgeSequence.hasNext()) {
                    this.edgeSequence = null;
                }
            }
            while (this.current == null && this.vertexSequence.hasNext()) {
                BasicIterator sequence;
                Iterator<Edge> iterator;
                Vertex v = this.vertexSequence.next();
                Resource id = v.getId();
                if (id instanceof BNode && v.inEdgeSet().iterator().hasNext() || !(iterator = v.outEdgeSet().iterator()).hasNext() || !(sequence = new BasicIterator(this.graph, iterator)).hasNext()) continue;
                this.current = sequence.next();
                this.edgeSequence = sequence.hasNext() ? sequence : null;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new KonigException("remove method not supported");
        }
    }
}

