/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Edge;
import io.konig.core.Vertex;
import io.konig.core.impl.VertexEdgeIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;

public class OutEdgeSet
implements Set<Edge> {
    Vertex vertex;
    Set<Map.Entry<URI, Set<Edge>>> edgeSet;

    public OutEdgeSet(Vertex vertex, Set<Map.Entry<URI, Set<Edge>>> outSet) {
        this.vertex = vertex;
        this.edgeSet = outSet;
    }

    @Override
    public boolean add(Edge e) {
        return this.vertex.getGraph().add(e);
    }

    @Override
    public boolean addAll(Collection<? extends Edge> c) {
        return this.vertex.getGraph().addAll(c);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.vertex.getGraph().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.vertex.getGraph().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.edgeSet.isEmpty();
    }

    @Override
    public Iterator<Edge> iterator() {
        return new VertexEdgeIterator(this.vertex.outEdges().iterator());
    }

    @Override
    public boolean remove(Object o) {
        return this.vertex.getGraph().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.vertex.getGraph().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.vertex.getGraph().retainAll(c);
    }

    @Override
    public int size() {
        int count = 0;
        for (Map.Entry<URI, Set<Edge>> e : this.edgeSet) {
            Set<Edge> s = e.getValue();
            count += s.size();
        }
        return count;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }
}

