/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.RewriteService;

public class ProxyIriRewriteService
implements RewriteService {
    private String canonicalBase;
    private String cacheBase;
    private String localBase;

    public ProxyIriRewriteService(String canonicalBase, String cacheBase, String localBase) {
        this.canonicalBase = canonicalBase;
        this.cacheBase = cacheBase;
        this.localBase = localBase;
    }

    @Override
    public String toLocal(String iri) {
        if (iri.startsWith(this.localBase)) {
            return iri;
        }
        if (iri.startsWith(this.canonicalBase)) {
            return this.simpleRewrite(this.canonicalBase, this.localBase, iri);
        }
        int colon = iri.indexOf(58);
        if (colon < 1) {
            throw new RuntimeException("Invalid IRI: " + iri);
        }
        String protocol = iri.substring(0, colon);
        String path = iri.substring(colon + 2);
        StringBuilder builder = new StringBuilder();
        builder.append(this.cacheBase);
        builder.append(protocol);
        builder.append(path);
        return builder.toString();
    }

    @Override
    public String fromLocal(String iri) {
        if (iri.startsWith(this.cacheBase)) {
            int start = this.cacheBase.length();
            int end = iri.indexOf(47, start);
            String protocol = iri.substring(start, end);
            String path = iri.substring(end + 1);
            StringBuilder builder = new StringBuilder();
            builder.append(protocol);
            builder.append("://");
            builder.append(path);
            return builder.toString();
        }
        if (iri.startsWith(this.localBase)) {
            return this.simpleRewrite(this.localBase, this.canonicalBase, iri);
        }
        return iri;
    }

    protected String simpleRewrite(String fromBaseIRI, String toBaseIRI, String iri) {
        String tail = iri.substring(fromBaseIRI.length());
        StringBuilder builder = new StringBuilder(toBaseIRI.length() + tail.length());
        builder.append(toBaseIRI);
        builder.append(tail);
        iri = builder.toString();
        return iri;
    }
}

