/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Context;
import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.Path;
import io.konig.core.Term;
import io.konig.core.Vertex;
import io.konig.core.impl.MemoryNamespaceManager;
import io.konig.core.impl.NaturalEdgeIterable;
import io.konig.core.io.CompactTurtleWriter;
import io.konig.core.io.CompositeRdfHandler;
import io.konig.core.io.GraphLoadHandler;
import io.konig.core.io.NamespaceRDFHandler;
import io.konig.core.io.PrettyPrintWriter;
import io.konig.core.io.TurtleConfig;
import io.konig.core.path.OutStep;
import io.konig.core.path.Step;
import io.konig.core.util.StringUtil;
import io.konig.core.vocab.Schema;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.io.ShapeLoader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.util.Literals;
import org.openrdf.model.vocabulary.DCTERMS;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.helpers.BasicWriterSettings;
import org.openrdf.rio.turtle.TurtleParserFactory;
import org.openrdf.rio.turtle.TurtleUtil;

public class RdfUtil {
    private static final int WORD = 1;
    private static final int COLON = 2;
    private static final int SLASH = 3;

    public static URI namespace(Graph graph, String value) {
        NamespaceManager nsManager = graph.getNamespaceManager();
        int index = value.length() - 1;
        index = value.lastIndexOf(47, index);
        while (index > 0) {
            String namespace = value.substring(0, index + 1);
            Namespace ns = nsManager.findByName(namespace);
            if (ns != null) {
                return (URI)graph.vertex((Resource)new URIImpl(namespace)).getId();
            }
            --index;
            index = value.lastIndexOf(47, index);
        }
        return null;
    }

    public static String compactId(Resource id, NamespaceManager nsManager) {
        if (id == null) {
            return null;
        }
        if (id instanceof BNode) {
            return "_:" + ((BNode)id).getID();
        }
        if (id instanceof URI) {
            URI iri = (URI)id;
            if (nsManager != null) {
                Namespace ns = nsManager.findByName(iri.getNamespace());
                if (ns != null) {
                    return ns.getPrefix() + ":" + iri.getLocalName();
                }
                return "<" + iri.stringValue() + ">";
            }
        }
        throw new IllegalArgumentException("Unsuppported Resource type: " + id.getClass().getName());
    }

    public static String localName(Resource id) {
        if (id == null) {
            return "null";
        }
        if (id instanceof BNode) {
            return ((BNode)id).getID();
        }
        if (id instanceof URI) {
            return ((URI)id).getLocalName();
        }
        throw new IllegalArgumentException("Unsuppported Resource type: " + id.getClass().getName());
    }

    public static int countDistinctProperties(Shape shape) {
        HashSet<Shape> memory = new HashSet<Shape>();
        return RdfUtil.countProperties(memory, shape);
    }

    private static int countProperties(Set<Shape> memory, Shape shape) {
        int count = 0;
        if (!memory.contains(shape)) {
            memory.add(shape);
            List<PropertyConstraint> list = shape.getProperty();
            count += list.size();
            for (PropertyConstraint p : list) {
                Shape childShape = p.getShape();
                if (childShape == null) continue;
                count = RdfUtil.countProperties(memory, childShape);
            }
        }
        return count;
    }

    public static List<Namespace> collectNamespaces(NamespaceManager nsManager, Collection<Edge> edgeList) {
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Edge e : edgeList) {
            Resource subject = e.getSubject();
            URI predicate = e.getPredicate();
            Value object = e.getObject();
            if (subject instanceof URI) {
                RdfUtil.addNamespace(map, nsManager, (URI)subject);
            }
            RdfUtil.addNamespace(map, nsManager, predicate);
            if (!(object instanceof URI)) continue;
            RdfUtil.addNamespace(map, nsManager, (URI)object);
        }
        return new ArrayList<Namespace>(map.values());
    }

    public static void sortByLocalName(List<PropertyConstraint> properties) {
        Collections.sort(properties, new Comparator<PropertyConstraint>(){

            @Override
            public int compare(PropertyConstraint a, PropertyConstraint b) {
                String aName = a.getPredicate() == null ? "" : a.getPredicate().getLocalName();
                String bName = b.getPredicate() == null ? "" : b.getPredicate().getLocalName();
                return aName.compareTo(bName);
            }
        });
    }

    public static boolean nearEqual(Object a, Object b) {
        if (a instanceof Long && b instanceof Long) {
            return a.equals(b);
        }
        if (a instanceof Number && b instanceof Number) {
            double base;
            Number x = (Number)a;
            Number y = (Number)b;
            double p = x.doubleValue();
            double q = y.doubleValue();
            double delta = Math.abs(q - p);
            double fraction = delta / (base = (q + p) / 2.0);
            return fraction < 1.0E-14;
        }
        return a.equals(b);
    }

    public static Object javaValue(Value value) {
        if (value instanceof Literal) {
            return RdfUtil.javaValue((Literal)value);
        }
        return value;
    }

    public static void append(StringBuilder builder, Resource id) {
        if (id instanceof BNode) {
            builder.append("_:");
            builder.append(id.stringValue());
        } else {
            builder.append('<');
            builder.append(id.stringValue());
            builder.append('>');
        }
    }

    public static void append(StringBuilder builder, Object value) {
        if (value instanceof String) {
            builder.append('\"');
            builder.append(value.toString());
            builder.append('\"');
        } else {
            builder.append(value);
        }
    }

    public static String idValue(Resource id) {
        StringBuilder builder = new StringBuilder();
        RdfUtil.append(builder, id);
        return builder.toString();
    }

    public static Set<Object> toJavaValue(Set<Value> source) {
        LinkedHashSet<Object> sink = new LinkedHashSet<Object>();
        for (Value v : source) {
            sink.add(RdfUtil.javaValue(v));
        }
        return sink;
    }

    public static Object javaValue(Literal literal) {
        String value = literal.getLabel();
        URI type = literal.getDatatype();
        if (XMLSchema.INTEGER.equals((Object)type) || XMLSchema.INT.equals((Object)type) || XMLSchema.LONG.equals((Object)type) || Schema.Integer.equals((Object)type)) {
            return Long.parseLong(value);
        }
        if (XMLSchema.DOUBLE.equals((Object)type) || XMLSchema.FLOAT.equals((Object)type) || XMLSchema.DECIMAL.equals((Object)type) || Schema.Float.equals((Object)type) || Schema.Number.equals((Object)type)) {
            return Double.parseDouble(value);
        }
        return literal;
    }

    public static NamespaceManager filterNamespaces(Graph graph, NamespaceManager nsManager) {
        MemoryNamespaceManager sink = new MemoryNamespaceManager();
        for (Edge e : graph) {
            Literal literal;
            URI type;
            Resource subject = e.getSubject();
            URI predicate = e.getPredicate();
            Value object = e.getObject();
            RdfUtil.copyNamespace(nsManager, (Value)subject, sink);
            RdfUtil.copyNamespace(nsManager, (Value)predicate, sink);
            RdfUtil.copyNamespace(nsManager, object, sink);
            if (!(object instanceof Literal) || (type = (literal = (Literal)object).getDatatype()) == null || XMLSchema.STRING.equals((Object)type)) continue;
            RdfUtil.copyNamespace(nsManager, (Value)type, sink);
        }
        return sink;
    }

    public static void deepCopy(Vertex v, Graph target) {
        if (v != null) {
            Graph g = v.getGraph();
            Set<Map.Entry<URI, Set<Edge>>> out = v.outEdges();
            for (Map.Entry<URI, Set<Edge>> entry : out) {
                Set<Edge> set = entry.getValue();
                for (Edge e : set) {
                    target.edge(e);
                    Value object = e.getObject();
                    if (!(object instanceof BNode)) continue;
                    BNode bnode = (BNode)object;
                    Vertex w = g.getVertex((Resource)bnode);
                    RdfUtil.deepCopy(w, target);
                }
            }
        }
    }

    private static void copyNamespace(NamespaceManager source, Value value, NamespaceManager sink) {
        URI uri;
        String name;
        Namespace ns;
        if (value instanceof URI && !RDF.TYPE.equals((Object)value) && (ns = source.findByName(name = (uri = (URI)value).getNamespace())) != null) {
            sink.add(ns);
        }
    }

    public static void sortByPrefix(List<Namespace> list) {
        Collections.sort(list, new Comparator<Namespace>(){

            @Override
            public int compare(Namespace a, Namespace b) {
                String x = a.getPrefix();
                String y = b.getPrefix();
                return x.compareTo(y);
            }
        });
    }

    private static void addNamespace(Map<String, Namespace> map, NamespaceManager nsManager, URI uri) {
        String key = uri.getNamespace();
        Namespace ns = nsManager.findByName(key);
        if (ns != null) {
            map.put(key, ns);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URI expand(NamespaceManager nsManager, String curie) throws KonigException {
        URIImpl result = null;
        if (curie == null) return result;
        if (RdfUtil.commonInternetScheme(curie)) return new URIImpl(curie);
        if (curie.startsWith("urn:")) return new URIImpl(curie);
        int colon = curie.indexOf(58);
        if (colon <= 0) return result;
        String prefix = curie.substring(0, colon);
        Namespace ns = nsManager.findByPrefix(prefix);
        if (ns == null) throw new KonigException("Namespace not found for prefix: " + prefix);
        StringBuilder builder = new StringBuilder();
        builder.append(ns.getName());
        builder.append(curie.substring(colon + 1));
        return new URIImpl(builder.toString());
    }

    private static boolean commonInternetScheme(String curie) {
        int state = 1;
        block5: for (int i = 0; i < curie.length(); ++i) {
            char c = curie.charAt(i);
            switch (state) {
                case 1: {
                    if (c == ':') {
                        state = 2;
                        continue block5;
                    }
                    if (Character.isLowerCase(c) || Character.isDigit(c) || c == '.' || c == '-' || c == '+') continue block5;
                    return false;
                }
                case 2: {
                    if (c == '/') {
                        state = 3;
                        continue block5;
                    }
                    return false;
                }
                case 3: {
                    return c == '/';
                }
            }
        }
        return false;
    }

    public static String curie(URI uri, NamespaceManager nsManager) {
        if (nsManager == null) {
            throw new KonigException("NamespaceManager must be defined");
        }
        Namespace ns = nsManager.findByName(uri.getNamespace());
        if (ns == null) {
            throw new KonigException("Prefix not found for namespace: " + uri.getNamespace());
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ns.getPrefix());
        builder.append(':');
        builder.append(uri.getLocalName());
        return builder.toString();
    }

    public static String optionalCurie(NamespaceManager nsManager, URI uri) {
        Namespace ns;
        if (nsManager != null && (ns = nsManager.findByName(uri.getNamespace())) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(ns.getPrefix());
            builder.append(':');
            builder.append(uri.getLocalName());
            return builder.toString();
        }
        return uri.stringValue();
    }

    public static String getDescription(Vertex subject) {
        Value value = null;
        value = subject.getValue(RDFS.COMMENT);
        return value != null ? value.stringValue() : ((value = subject.getValue(DCTERMS.DESCRIPTION)) != null ? value.stringValue() : ((value = subject.getValue(Schema.description)) != null ? value.stringValue() : null));
    }

    public static String getDescription(PropertyConstraint p, Graph graph) {
        Vertex v;
        URI predicate;
        String result = p.getComment();
        if (result == null && (predicate = p.getPredicate()) != null && graph != null && (v = graph.getVertex((Resource)predicate)) != null) {
            result = RdfUtil.getDescription(v);
        }
        return result;
    }

    public static List<Vertex> listSubtypes(List<Vertex> typeList) {
        Graph graph = null;
        if (!typeList.isEmpty()) {
            graph = typeList.get(0).getGraph();
        }
        HashSet<Resource> set = new HashSet<Resource>();
        for (Vertex v : typeList) {
            set.add(v.getId());
            Set<Resource> subTypes = RdfUtil.subTypes(v);
            set.addAll(subTypes);
        }
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        for (Resource r : set) {
            result.add(graph.getVertex(r));
        }
        return result;
    }

    public static String normalize(String value) {
        if (value != null) {
            StringTokenizer tokens = new StringTokenizer(value, "\r\n\t ");
            StringBuilder builder = new StringBuilder();
            while (tokens.hasMoreTokens()) {
                builder.append(tokens.nextToken());
                if (!tokens.hasMoreTokens()) continue;
                builder.append(' ');
            }
            value = builder.toString();
        }
        return value;
    }

    public static void prettyPrintTurtle(Graph graph, OutputStream out) throws IOException, RDFHandlerException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        RdfUtil.prettyPrintTurtle(graph.getNamespaceManager(), graph, (Writer)writer);
        writer.flush();
    }

    public static void prettyPrintTurtle(Graph graph, Writer writer) throws IOException, RDFHandlerException {
        RdfUtil.prettyPrintTurtle(graph.getNamespaceManager(), graph, writer);
    }

    public static void prettyPrintTurtle(String baseIri, Graph graph, Writer writer) throws IOException, RDFHandlerException {
        RdfUtil.prettyPrintTurtle(graph.getNamespaceManager(), baseIri, graph, writer);
    }

    public static void prettyPrintTurtle(NamespaceManager nsManager, Graph graph, Writer writer) throws IOException, RDFHandlerException {
        RdfUtil.prettyPrintTurtle(nsManager, null, graph, writer);
    }

    public static void prettyPrintTurtle(NamespaceManager nsManager, String baseIRI, Graph graph, Writer writer) throws IOException, RDFHandlerException {
        RdfUtil.prettyPrintTurtle(nsManager, baseIRI, graph, writer, null);
    }

    public static void prettyPrintTurtle(NamespaceManager nsManager, String baseIRI, Graph graph, Writer writer, TurtleConfig config) throws IOException, RDFHandlerException {
        nsManager = nsManager == null ? null : RdfUtil.filterNamespaces(graph, nsManager);
        CompactTurtleWriter turtle = new CompactTurtleWriter(writer);
        if (config != null) {
            turtle.setConfig(config);
        }
        turtle.setBaseIRI(baseIRI);
        turtle.getWriterConfig().set(BasicWriterSettings.PRETTY_PRINT, (Object)true);
        NaturalEdgeIterable sequence = new NaturalEdgeIterable(graph);
        turtle.startRDF();
        RdfUtil.printNamespaces(nsManager, turtle);
        for (Edge e : sequence) {
            turtle.handleStatement(e);
        }
        turtle.endRDF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prettyPrintTurtle(NamespaceManager nsManager, Graph graph, File file) throws IOException, RDFHandlerException {
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file);){
            RdfUtil.prettyPrintTurtle(nsManager, graph, (Writer)writer);
        }
    }

    private static void printNamespaces(NamespaceManager namespaceManager, CompactTurtleWriter turtle) throws RDFHandlerException {
        if (namespaceManager != null) {
            ArrayList<Namespace> list = new ArrayList<Namespace>(namespaceManager.listNamespaces());
            Collections.sort(list, new Comparator<Namespace>(){

                @Override
                public int compare(Namespace a, Namespace b) {
                    return a.getPrefix().compareTo(b.getPrefix());
                }
            });
            for (Namespace n : list) {
                turtle.handleNamespace(n.getPrefix(), n.getName());
            }
        }
    }

    public static void loadTurtle(Graph graph, NamespaceManager nsManager, InputStream input, String baseURL) throws IOException, RDFParseException, RDFHandlerException {
        CompositeRdfHandler handler = new CompositeRdfHandler(new RDFHandler[]{new GraphLoadHandler(graph), new NamespaceRDFHandler(nsManager)});
        RDFParser parser = new TurtleParserFactory().getParser();
        parser.setRDFHandler((RDFHandler)handler);
        InputStreamReader reader = new InputStreamReader(input);
        parser.parse((Reader)reader, baseURL);
    }

    public static void loadTurtle(File sourceDir, Graph graph, ShapeManager shapeManager) throws RDFParseException, RDFHandlerException, IOException {
        RdfUtil.loadTurtle(sourceDir, graph, graph.getNamespaceManager());
        ShapeLoader shapeLoader = new ShapeLoader(shapeManager);
        shapeLoader.load(graph);
    }

    public static void loadTurtle(File sourceDir, Graph graph) throws RDFParseException, RDFHandlerException, IOException {
        RdfUtil.loadTurtle(sourceDir, graph, graph.getNamespaceManager());
    }

    public static void loadTurtle(File sourceDir, Graph graph, NamespaceManager nsManager) throws IOException, RDFParseException, RDFHandlerException {
        Object handler = new GraphLoadHandler(graph);
        if (nsManager != null) {
            handler = new CompositeRdfHandler(new RDFHandler[]{handler, new NamespaceRDFHandler(nsManager)});
        }
        RDFParser parser = new TurtleParserFactory().getParser();
        parser.setRDFHandler((RDFHandler)handler);
        RdfUtil.loadTurtle(sourceDir, parser);
    }

    private static void loadTurtle(File sourceDir, RDFParser parser) throws RDFParseException, RDFHandlerException, IOException {
        File[] array = sourceDir.listFiles();
        if (array != null) {
            for (File file : array) {
                if (file.isDirectory()) {
                    RdfUtil.loadTurtle(file, parser);
                    continue;
                }
                if (!file.getName().endsWith(".ttl")) continue;
                try {
                    FileReader input = new FileReader(file);
                    parser.parse((Reader)input, "");
                }
                catch (RDFParseException e) {
                    throw new RDFParseException("Failed to parse file: " + file.getAbsolutePath(), (Throwable)e);
                }
                catch (RDFHandlerException e) {
                    throw new RDFHandlerException("Failed to parse file: " + file.getAbsolutePath(), (Throwable)e);
                }
                catch (IOException e) {
                    throw new IOException("Failed to parse file: " + file.getAbsolutePath(), e);
                }
            }
        }
    }

    public static void loadTurtle(Graph graph, Reader input, String baseURL) throws RDFParseException, RDFHandlerException, IOException {
        GraphLoadHandler handler = new GraphLoadHandler(graph);
        RDFParser parser = new TurtleParserFactory().getParser();
        parser.setRDFHandler((RDFHandler)handler);
        parser.parse(input, baseURL);
    }

    public static void loadTurtle(Graph graph, InputStream input, String baseURL) throws IOException, RDFParseException, RDFHandlerException {
        InputStreamReader reader = new InputStreamReader(input);
        RdfUtil.loadTurtle(graph, reader, baseURL);
    }

    public static Set<Resource> superTypes(Vertex owlClass) {
        HashSet<Resource> result = new HashSet<Resource>();
        ArrayList<Vertex> stack = new ArrayList<Vertex>();
        stack.add(owlClass);
        for (int i = 0; i < stack.size(); ++i) {
            Vertex target = (Vertex)stack.get(i);
            List<Vertex> list = target.asTraversal().out(RDFS.SUBCLASSOF).toVertexList();
            for (Vertex v : list) {
                Resource id = v.getId();
                if (id.equals(owlClass.getId()) || result.contains(id)) continue;
                result.add(id);
                stack.add(v);
            }
        }
        return result;
    }

    public static List<Vertex> subtypeList(Vertex owlClass) {
        return owlClass.asTraversal().inTransitive(RDFS.SUBCLASSOF).toVertexList();
    }

    public static Set<Resource> subTypes(Vertex owlClass) {
        HashSet<Resource> result = new HashSet<Resource>();
        ArrayList<Vertex> stack = new ArrayList<Vertex>();
        stack.add(owlClass);
        for (int i = 0; i < stack.size(); ++i) {
            Vertex target = (Vertex)stack.get(i);
            List<Vertex> list = target.asTraversal().in(RDFS.SUBCLASSOF).toVertexList();
            for (Vertex v : list) {
                Resource id = v.getId();
                if (id.equals(owlClass.getId()) || result.contains(id)) continue;
                result.add(id);
                stack.add(v);
            }
        }
        return result;
    }

    public static URI out(Path path, int index) {
        Step s;
        List<Step> list;
        if (path != null && index < (list = path.asList()).size() && (s = list.get(index)) instanceof OutStep) {
            return ((OutStep)s).getPredicate();
        }
        return null;
    }

    public static boolean isSubClassOf(Vertex subject, Resource target) {
        List<Vertex> list = subject.asTraversal().out(RDFS.SUBCLASSOF).toVertexList();
        for (Vertex v : list) {
            if (!v.getId().equals(target)) continue;
            return true;
        }
        for (Vertex v : list) {
            if (!RdfUtil.isSubClassOf(v, target)) continue;
            return true;
        }
        return false;
    }

    public static String toTurtle(Literal literal) {
        StringWriter writer = new StringWriter();
        PrettyPrintWriter out = new PrettyPrintWriter(writer);
        RdfUtil.writeLiteral(out, literal);
        out.flush();
        return writer.toString();
    }

    public static void writeLiteral(PrettyPrintWriter writer, Literal literal) {
        String label = literal.getLabel();
        URI datatype = literal.getDatatype();
        if (XMLSchema.INTEGER.equals((Object)datatype) || XMLSchema.DECIMAL.equals((Object)datatype) || XMLSchema.DOUBLE.equals((Object)datatype) || XMLSchema.BOOLEAN.equals((Object)datatype)) {
            try {
                writer.write(XMLDatatypeUtil.normalize((String)label, (URI)datatype));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (label.indexOf(10) != -1 || label.indexOf(13) != -1 || label.indexOf(9) != -1) {
            writer.write("\"\"\"");
            writer.write(TurtleUtil.encodeLongString((String)label));
            writer.write("\"\"\"");
        } else {
            writer.write("\"");
            writer.write(TurtleUtil.encodeString((String)label));
            writer.write("\"");
        }
        if (Literals.isLanguageLiteral((Literal)literal)) {
            writer.write("@");
            writer.write(literal.getLanguage());
        } else if (!XMLSchema.STRING.equals((Object)datatype)) {
            writer.write("^^");
            RdfUtil.writeURI(writer, datatype);
        }
    }

    public static void writeURI(PrettyPrintWriter out, URI uri) {
        Namespace ns;
        NamespaceManager nsManager = out.getNamespaceManager();
        if (nsManager != null && (ns = nsManager.findByName(uri.getNamespace())) != null) {
            out.print(ns.getPrefix());
            out.print(':');
            out.print(uri.getLocalName());
            return;
        }
        out.print('<');
        out.print(uri.stringValue());
        out.print('>');
    }

    public static String compactName(NamespaceManager nsManager, Resource resource) {
        URI id;
        Namespace ns;
        if (resource == null) {
            return null;
        }
        if (resource instanceof BNode) {
            return "_:" + ((BNode)resource).getID();
        }
        String iriValue = resource.stringValue();
        if (nsManager != null && (ns = nsManager.findByName((id = (URI)resource).getNamespace())) != null) {
            String prefix = ns.getPrefix();
            StringBuilder builder = new StringBuilder();
            builder.append(prefix);
            builder.append(':');
            builder.append(id.getLocalName());
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        builder.append(iriValue);
        builder.append('>');
        return builder.toString();
    }

    public static String compactName(Context context, URI resource) {
        String iriValue = resource.stringValue();
        if (context != null) {
            Context inverse = context.inverse();
            Term term = inverse.getTerm(iriValue);
            if (term != null) {
                return term.getId();
            }
            term = inverse.getTerm(resource.getNamespace());
            if (term != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(term.getId());
                builder.append(':');
                builder.append(resource.getLocalName());
                return builder.toString();
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        builder.append(iriValue);
        builder.append('>');
        return builder.toString();
    }

    public static URI uri(Value value) {
        return value instanceof URI ? (URI)value : null;
    }

    public static String shortShapeName(Resource id) {
        URI uri = RdfUtil.uri((Value)id);
        if (uri != null) {
            String name = uri.getLocalName();
            if (name.endsWith("Shape")) {
                name = name.substring(0, name.length() - 5);
            }
            return name;
        }
        return null;
    }

    public static String getName(Vertex v) {
        if (v != null) {
            Value name = v.getValue(Schema.name);
            if (name == null) {
                name = v.getValue(RDFS.LABEL);
            }
            if (name != null) {
                return name.stringValue();
            }
            String localName = RdfUtil.localName(v.getId());
            return StringUtil.label(localName);
        }
        return null;
    }
}

