/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.util.ValueFormat;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class ShapeIdGenerator {
    private NamespaceManager nsManager;
    private ShapeManager shapeManager;
    private ValueFormat template;

    public ShapeIdGenerator(NamespaceManager nsManager, ShapeManager shapeManager, ValueFormat template) {
        this.nsManager = nsManager;
        this.shapeManager = shapeManager;
        this.template = template;
    }

    public URI forShape(URI shapeId) {
        StringBuilder builder = new StringBuilder();
        block16: for (ValueFormat.Element element : this.template.toList()) {
            String text = element.getText();
            if (element.getType() == ValueFormat.ElementType.TEXT) {
                builder.append(text);
                continue;
            }
            URI targetClass = null;
            switch (text) {
                case "shapeId": {
                    builder.append(shapeId.stringValue());
                    continue block16;
                }
                case "shapeLocalName": {
                    builder.append(shapeId.getLocalName());
                    continue block16;
                }
                case "shapeNamespacePrefix": {
                    Namespace shapeNamespace = this.namespace(shapeId);
                    builder.append(shapeNamespace.getPrefix());
                    continue block16;
                }
                case "targetClassId": {
                    builder.append(this.targetClass(shapeId).stringValue());
                    continue block16;
                }
                case "targetClassLocalName": {
                    targetClass = this.targetClass(shapeId);
                    builder.append(targetClass.getLocalName());
                    continue block16;
                }
                case "targetClassNamespacePrefix": {
                    targetClass = this.targetClass(shapeId);
                    Namespace classNamespace = this.namespace(targetClass);
                    builder.append(classNamespace.getPrefix());
                    continue block16;
                }
            }
            throw new KonigException("Unsupported variable: " + text);
        }
        return new URIImpl(builder.toString());
    }

    protected Namespace namespace(URI uri) {
        Namespace ns = this.nsManager.findByName(uri.getNamespace());
        if (ns == null) {
            throw new KonigException("Namespace not found: " + uri.getNamespace());
        }
        return ns;
    }

    private URI targetClass(URI shapeId) {
        Shape shape = this.shapeManager.getShapeById((Resource)shapeId);
        if (shape == null) {
            throw new KonigException("Shape not found: " + shapeId);
        }
        URI targetClass = shape.getTargetClass();
        if (targetClass == null) {
            throw new KonigException("Target class not defined on Shape " + shapeId);
        }
        return targetClass;
    }
}

