/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Graph;
import io.konig.core.LocalNameService;
import io.konig.core.Vertex;
import io.konig.core.vocab.AS;
import io.konig.core.vocab.GCP;
import io.konig.core.vocab.Konig;
import io.konig.core.vocab.OMCS;
import io.konig.core.vocab.PROV;
import io.konig.core.vocab.SH;
import io.konig.core.vocab.Schema;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class SimpleLocalNameService
implements LocalNameService {
    private static final SimpleLocalNameService DEFAULT = new SimpleLocalNameService();
    private static final Set<URI> EMPTYSET;
    private Map<String, Set<URI>> map = new HashMap<String, Set<URI>>();

    public static SimpleLocalNameService getDefaultInstance() {
        return DEFAULT;
    }

    public void addAll(Graph graph) {
        for (Vertex v : graph.vertices()) {
            Resource id = v.getId();
            if (!(id instanceof URI)) continue;
            URI uri = (URI)id;
            this.add(uri);
        }
    }

    public void addShapes(Collection<Shape> shapeList) {
        for (Shape s : shapeList) {
            this.addShape(s);
        }
    }

    public void addShape(Shape s) {
        HashSet<Shape> memory = new HashSet<Shape>();
        this.doAddShape(memory, s);
    }

    private void doAddShape(Set<Shape> memory, Shape s) {
        if (!memory.contains(s)) {
            memory.add(s);
            this.addPropertyConstraints(memory, s.getProperty());
            this.addPropertyConstraints(memory, s.getDerivedProperty());
        }
    }

    private void addPropertyConstraints(Set<Shape> memory, Collection<PropertyConstraint> propertyList) {
        for (PropertyConstraint p : propertyList) {
            this.safeAdd(p.getPredicate());
            Shape shape = p.getShape();
            if (shape == null) continue;
            this.doAddShape(memory, shape);
        }
    }

    private void safeAdd(URI uri) {
        if (uri != null) {
            this.add(uri);
        }
    }

    public void add(URI uri) {
        this.add(uri.getLocalName(), uri);
    }

    public void add(String localName, URI uri) {
        Set<URI> set = this.map.get(localName);
        if (set == null) {
            set = new HashSet<URI>();
            this.map.put(localName, set);
        }
        set.add(uri);
    }

    @Override
    public Set<URI> lookupLocalName(String localName) {
        Set<URI> result = this.map.get(localName);
        return result == null ? EMPTYSET : result;
    }

    public void addStaticFields(Class<?> javaClass) {
        Field[] declaredFields;
        for (Field field : declaredFields = javaClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !URI.class.isAssignableFrom(field.getType())) continue;
            try {
                URI value = (URI)field.get(null);
                this.add(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        DEFAULT.addStaticFields(Konig.class);
        DEFAULT.addStaticFields(SH.class);
        DEFAULT.addStaticFields(AS.class);
        DEFAULT.addStaticFields(Schema.class);
        DEFAULT.addStaticFields(PROV.class);
        DEFAULT.addStaticFields(RDF.class);
        DEFAULT.addStaticFields(RDFS.class);
        DEFAULT.addStaticFields(GCP.class);
        DEFAULT.addStaticFields(OMCS.class);
        EMPTYSET = new HashSet<URI>();
    }
}

