/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Traversal;
import io.konig.core.Vertex;
import io.konig.core.impl.KonigLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;

public class TraversalImpl
implements Traversal {
    private Graph graph;
    private List<Object> list = new ArrayList<Object>();

    public TraversalImpl(Graph g) {
        this.graph = g;
    }

    public TraversalImpl(Vertex v) {
        this.graph = v.getGraph();
        this.list.add(v);
    }

    public TraversalImpl(Graph g, List<?> list) {
        this.graph = g;
        this.list = list;
    }

    @Override
    public Traversal has(URI property) {
        TraversalImpl result = new TraversalImpl(this.graph);
        List<Object> sink = result.list;
        for (Object e : this.list) {
            Vertex v;
            Set<Edge> set;
            if (!(e instanceof Vertex) || (set = (v = (Vertex)e).outProperty(property)).isEmpty()) continue;
            sink.add(v);
        }
        return result;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Traversal hasValue(URI property, Value value) {
        TraversalImpl result = new TraversalImpl(this.graph);
        List<Object> sink = result.list;
        for (Object e : this.list) {
            if (!(e instanceof Vertex)) continue;
            Vertex v = (Vertex)e;
            Set<Edge> set = v.outProperty(property);
            for (Edge edge : set) {
                Value object = edge.getObject();
                if (!value.equals(object)) continue;
                sink.add(v);
            }
        }
        return result;
    }

    @Override
    public Traversal addProperty(URI property, Value value) {
        for (Object e : this.list) {
            if (!(e instanceof Vertex)) continue;
            Vertex v = (Vertex)e;
            v.getGraph().edge(v.getId(), property, value);
        }
        return this;
    }

    @Override
    public Traversal addObject(String property, String iri) {
        return this.addProperty(this.uri(property), (Value)this.uri(iri));
    }

    @Override
    public Traversal addLiteral(String property, String value) {
        return this.addProperty(this.uri(property), (Value)this.literal(value));
    }

    public Literal literal(String value) {
        return new KonigLiteral(value);
    }

    public URI uri(String value) {
        return new URIImpl(value);
    }

    @Override
    public Traversal addV(Resource ... iri) {
        TraversalImpl result = new TraversalImpl(this.graph);
        for (int i = 0; i < iri.length; ++i) {
            Vertex v = this.graph.vertex(iri[i]);
            result.list.add(v);
        }
        return result;
    }

    @Override
    public Traversal addLiteral(URI property, String value) {
        return this.addProperty(property, (Value)this.literal(value));
    }

    @Override
    public URI firstIRI(URI predicate) {
        for (Object e : this.list) {
            Vertex v;
            Resource r;
            if (e instanceof Vertex && (r = (v = (Vertex)e).getId()) instanceof URI) {
                return (URI)r;
            }
            if (!(e instanceof URI)) continue;
            return (URI)e;
        }
        return null;
    }

    @Override
    public Value firstValue(URI predicate) {
        for (Object e : this.list) {
            Vertex v;
            Set<Edge> set;
            Iterator<Edge> iterator;
            if (!(e instanceof Vertex) || !(iterator = (set = (v = (Vertex)e).outProperty(predicate)).iterator()).hasNext()) continue;
            Edge edge = iterator.next();
            return edge.getObject();
        }
        return null;
    }

    @Override
    public Traversal hasValue(URI property, String value) {
        TraversalImpl result = new TraversalImpl(this.graph);
        List<Object> sink = result.list;
        for (Object e : this.list) {
            if (!(e instanceof Vertex)) continue;
            Vertex v = (Vertex)e;
            Set<Edge> set = v.outProperty(property);
            for (Edge edge : set) {
                Value object = edge.getObject();
                if (!value.equals(object.stringValue())) continue;
                sink.add(v);
            }
        }
        return result;
    }

    @Override
    public Traversal out(URI predicate) {
        TraversalImpl result = new TraversalImpl(this.graph);
        List<Object> sink = result.list;
        for (Object e : this.list) {
            if (!(e instanceof Vertex)) continue;
            Vertex v = (Vertex)e;
            Set<Edge> set = v.outProperty(predicate);
            for (Edge edge : set) {
                Value object = edge.getObject();
                if (object instanceof Resource) {
                    Vertex outV = this.graph.vertex((Resource)object);
                    sink.add(outV);
                    continue;
                }
                sink.add(object);
            }
        }
        return result;
    }

    @Override
    public Vertex firstVertex(URI predicate) {
        for (Object e : this.list) {
            if (!(e instanceof Vertex)) continue;
            Vertex v = (Vertex)e;
            Set<Edge> set = v.outProperty(predicate);
            for (Edge edge : set) {
                Value object = edge.getObject();
                if (!(object instanceof Resource)) continue;
                return this.graph.vertex((Resource)object);
            }
        }
        return null;
    }

    @Override
    public Traversal in(URI predicate) {
        TraversalImpl result = new TraversalImpl(this.graph);
        List<Object> sink = result.list;
        for (Object e : this.list) {
            if (!(e instanceof Vertex)) continue;
            Vertex v = (Vertex)e;
            Set<Edge> set = v.inProperty(predicate);
            for (Edge edge : set) {
                Resource subject = edge.getSubject();
                sink.add(this.graph.vertex(subject));
            }
        }
        return result;
    }

    @Override
    public Vertex firstVertex() {
        for (Object obj : this.list) {
            if (!(obj instanceof Vertex)) continue;
            return (Vertex)obj;
        }
        return null;
    }

    @Override
    public List<Vertex> toVertexList() {
        if (this.list.isEmpty() || this.list.get(0) instanceof Vertex) {
            return this.list;
        }
        return null;
    }

    @Override
    public void addValues(Set<Value> set) {
        for (Object obj : this.list) {
            if (obj instanceof Value) {
                set.add((Value)obj);
                continue;
            }
            if (!(obj instanceof Vertex)) continue;
            Vertex v = (Vertex)obj;
            set.add((Value)v.getId());
        }
    }

    @Override
    public List<Value> toValueList() {
        if (this.list.isEmpty() || this.list.get(0) instanceof Value) {
            return this.list;
        }
        ArrayList<Value> result = new ArrayList<Value>();
        for (Object obj : this.list) {
            if (obj instanceof Vertex) {
                Vertex v = (Vertex)obj;
                result.add((Value)v.getId());
                continue;
            }
            if (!(obj instanceof Value)) continue;
            result.add((Value)obj);
        }
        return result;
    }

    @Override
    public Set<URI> toUriSet() {
        HashSet<URI> result = new HashSet<URI>();
        for (Object obj : this.list) {
            if (obj instanceof Vertex) {
                Vertex v = (Vertex)obj;
                if (!(v.getId() instanceof URI)) continue;
                result.add((URI)v.getId());
                continue;
            }
            if (!(obj instanceof URI)) continue;
            result.add((URI)obj);
        }
        return result;
    }

    @Override
    public Traversal distinct() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object value : this.list) {
            Vertex v;
            if (value instanceof Vertex) {
                v = (Vertex)value;
                map.put(v.getId().stringValue(), v);
                continue;
            }
            if (!(value instanceof Value)) continue;
            v = (Value)value;
            map.put(v.stringValue(), value);
        }
        this.list = new ArrayList(map.values());
        return this;
    }

    @Override
    public Traversal outTransitive(URI predicate) {
        HashMap<String, Vertex> closure = new HashMap<String, Vertex>();
        for (int i = 0; i < this.list.size(); ++i) {
            Vertex v;
            Object element = this.list.get(i);
            Vertex vertex = element instanceof Vertex ? (Vertex)element : (v = element instanceof Resource ? this.graph.vertex((Resource)element) : null);
            if (v == null) continue;
            Set<Edge> out = v.outProperty(predicate);
            for (Edge e : out) {
                Value object = e.getObject();
                if (closure.containsKey(object.stringValue()) || !(object instanceof Resource)) continue;
                Vertex next = this.graph.vertex((Resource)object);
                this.list.add(next);
                closure.put(object.stringValue(), next);
            }
        }
        this.list = new ArrayList(closure.values());
        return this;
    }

    @Override
    public Traversal inTransitive(URI predicate) {
        HashMap<String, Vertex> closure = new HashMap<String, Vertex>();
        for (int i = 0; i < this.list.size(); ++i) {
            Vertex v;
            Object element = this.list.get(i);
            Vertex vertex = element instanceof Vertex ? (Vertex)element : (v = element instanceof Resource ? this.graph.vertex((Resource)element) : null);
            if (v == null) continue;
            Set<Edge> in = v.inProperty(predicate);
            for (Edge e : in) {
                Resource subject = e.getSubject();
                if (closure.containsKey(subject.stringValue()) || !(subject instanceof Resource)) continue;
                Vertex next = this.graph.vertex(subject);
                this.list.add(next);
                closure.put(subject.stringValue(), next);
            }
        }
        this.list = new ArrayList(closure.values());
        return this;
    }

    @Override
    public Traversal union(Vertex v) {
        for (Object obj : this.list) {
            Vertex w;
            if (obj instanceof Vertex && (w = (Vertex)obj).getId().equals(v.getId())) {
                return this;
            }
            if (!(obj instanceof Value)) continue;
            w = (Value)obj;
            if (!v.getId().stringValue().equals(w.stringValue())) continue;
            return this;
        }
        this.list.add(v);
        return this;
    }

    @Override
    public Traversal union(Set<? extends Value> param) {
        for (Value value : param) {
            if (value instanceof Resource) {
                this.union(this.graph.vertex((Resource)value));
                continue;
            }
            for (Object obj : this.list) {
                Value w;
                if (!(obj instanceof Value) || !(w = (Value)obj).equals(value)) continue;
                return this;
            }
            this.list.add(value);
        }
        return this;
    }

    @Override
    public Traversal union(Value ... param) {
        for (Value v : param) {
            if (v instanceof Resource) {
                this.union(this.graph.vertex((Resource)v));
                continue;
            }
            for (Object obj : this.list) {
                Value w;
                if (!(obj instanceof Value) || !(w = (Value)obj).equals(v)) continue;
                return this;
            }
            this.list.add(v);
        }
        return this;
    }

    @Override
    public Traversal isIRI() {
        TraversalImpl result = new TraversalImpl(this.graph);
        List<Object> sink = result.list;
        for (Object obj : this.list) {
            Vertex v;
            Resource id;
            if (!(obj instanceof Vertex) || !((id = (v = (Vertex)obj).getId()) instanceof URI)) continue;
            sink.add(v);
        }
        return result;
    }

    @Override
    public Literal firstLiteral(URI predicate) {
        Value value = this.firstValue(predicate);
        return value instanceof Literal ? (Literal)value : null;
    }
}

