/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Vertex;
import io.konig.core.impl.ResourceVertex;
import io.konig.core.impl.VertexImpl;
import org.openrdf.model.URI;

public class URIVertex
implements URI,
ResourceVertex {
    private static final long serialVersionUID = 1L;
    private Vertex vertex;
    private String stringValue;
    private String namespace;
    private String localName;

    public URIVertex(String iriValue, Vertex vertex) {
        if (iriValue.indexOf(58) < 0) {
            throw new IllegalArgumentException("Invalid URI: " + iriValue);
        }
        this.stringValue = iriValue;
        this.vertex = vertex;
    }

    @Override
    public Vertex getVertex() {
        return this.vertex;
    }

    @Override
    public VertexImpl getVertexImpl() {
        return (VertexImpl)this.vertex;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public String getNamespace() {
        if (this.namespace == null) {
            this.parse();
        }
        return this.namespace;
    }

    private void parse() {
        int slash = this.stringValue.lastIndexOf(47);
        int colon = this.stringValue.lastIndexOf(58);
        int hash = this.stringValue.lastIndexOf(35);
        int mark = Math.max(slash, colon);
        mark = Math.max(mark, hash);
        this.namespace = this.stringValue.substring(0, ++mark);
        this.localName = this.stringValue.substring(mark);
    }

    public String getLocalName() {
        if (this.localName == null) {
            this.parse();
        }
        return this.localName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof URI) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.stringValue.hashCode();
    }

    public String toString() {
        return this.stringValue;
    }
}

