/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.impl;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.Traversal;
import io.konig.core.Vertex;
import io.konig.core.impl.BNodeVertex;
import io.konig.core.impl.EdgeImpl;
import io.konig.core.impl.EdgeMapImpl;
import io.konig.core.impl.InEdgeSet;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.impl.OutEdgeSet;
import io.konig.core.impl.TraversalImpl;
import io.konig.core.impl.URIVertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class VertexImpl
implements Vertex {
    private transient Graph graph;
    private Graph namedGraph;
    private Resource id;
    private EdgeMapImpl out = new EdgeMapImpl();
    private EdgeMapImpl in = new EdgeMapImpl();
    private static Set<Edge> emptySet = new HashSet<Edge>();

    public VertexImpl(Graph graph, Resource id) {
        this.graph = graph;
        this.id = id instanceof URI ? new URIVertex(id.stringValue(), this) : new BNodeVertex(id.stringValue(), this);
    }

    @Override
    public Resource getId() {
        return this.id;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    public void add(Edge e) {
        if (e.getSubject().equals(this.id)) {
            this.out.add(e);
        }
        if (e.getObject().equals(this.id)) {
            this.in.add(e);
        }
    }

    @Override
    public Set<Edge> outProperty(URI predicate) {
        Set<Edge> result = this.out.get(predicate);
        return result == null ? emptySet : result;
    }

    @Override
    public Set<Edge> inProperty(URI predicate) {
        Set<Edge> result = this.in.get(predicate);
        return result == null ? emptySet : result;
    }

    @Override
    public Set<Map.Entry<URI, Set<Edge>>> inEdges() {
        return this.in.entries();
    }

    @Override
    public Set<Map.Entry<URI, Set<Edge>>> outEdges() {
        return this.out.entries();
    }

    @Override
    public Traversal asTraversal() {
        return new TraversalImpl(this);
    }

    @Override
    public void remove(Edge edge) {
        if (edge.getSubject().equals(this.id)) {
            Set<Edge> out = this.outProperty(edge.getPredicate());
            out.remove(edge);
        }
        if (edge.getObject().equals(this.id)) {
            Set<Edge> in = this.inProperty(edge.getPredicate());
            in.remove(edge);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id.stringValue());
        builder.append('\n');
        this.appendProperties(builder, this, 1);
        return builder.toString();
    }

    private void appendValue(StringBuilder builder, Value value, int depth) {
        if (value instanceof BNode) {
            this.appendBNode(builder, (BNode)value, depth);
        } else {
            builder.append(value.stringValue());
            builder.append('\n');
        }
    }

    private void appendBNode(StringBuilder builder, BNode value, int depth) {
        Vertex node = this.graph.getVertex((Resource)value);
        builder.append("[ <");
        builder.append(value.getID());
        builder.append(">\n");
        this.appendProperties(builder, node, ++depth);
        this.indent(builder, --depth);
        builder.append("]\n");
    }

    private void appendProperties(StringBuilder builder, Vertex node, int depth) {
        if (node == null) {
            return;
        }
        Set<Map.Entry<URI, Set<Edge>>> out = node.outEdges();
        for (Map.Entry<URI, Set<Edge>> entry : out) {
            URI predicate = entry.getKey();
            Set<Edge> edges = entry.getValue();
            this.indent(builder, depth);
            int size = edges.size();
            if (size <= 0) continue;
            builder.append(predicate.getLocalName());
            if (size == 1) {
                Value value = edges.iterator().next().getObject();
                builder.append(' ');
                this.appendValue(builder, value, depth);
                continue;
            }
            builder.append('\n');
            ++depth;
            for (Edge e : edges) {
                Value value = e.getObject();
                this.indent(builder, depth);
                this.appendValue(builder, value, depth);
            }
            --depth;
        }
    }

    private void indent(StringBuilder builder, int depth) {
        for (int i = 0; i < depth; ++i) {
            builder.append("  ");
        }
    }

    @Override
    public Graph asNamedGraph() {
        return this.namedGraph;
    }

    @Override
    public Graph assertNamedGraph() {
        if (this.namedGraph == null) {
            this.namedGraph = new MemoryGraph();
            this.namedGraph.setId(this.id);
        }
        return this.namedGraph;
    }

    @Override
    public boolean hasEdge(Edge edge) {
        Set<Edge> set = edge.getSubject().equals(this.id) ? this.outProperty(edge.getPredicate()) : this.inProperty(edge.getPredicate());
        return set.contains(edge);
    }

    @Override
    public Set<Edge> outEdgeSet() {
        return new OutEdgeSet(this, this.outEdges());
    }

    @Override
    public Set<Edge> inEdgeSet() {
        return new InEdgeSet(this, this.in.entries());
    }

    @Override
    public List<Value> asList() {
        ArrayList<Value> result = null;
        Vertex v = this;
        while (v != null) {
            Edge restEdge;
            Iterator<Edge> sequence;
            VertexImpl w = v;
            v = null;
            Set<Edge> first = w.outProperty(RDF.FIRST);
            if (first == null || !(sequence = first.iterator()).hasNext()) continue;
            Edge firstEdge = sequence.next();
            Value object = firstEdge.getObject();
            if (result == null) {
                result = new ArrayList();
            }
            result.add(object);
            Set<Edge> rest = w.outProperty(RDF.REST);
            if (rest == null || !(sequence = rest.iterator()).hasNext() || RDF.NIL.equals((Object)(object = (restEdge = sequence.next()).getObject())) || !(object instanceof Resource)) continue;
            v = this.graph.getVertex((Resource)object);
        }
        if (result == null && (RDF.NIL.equals((Object)this.id) || this.hasProperty(RDF.TYPE, (Value)RDF.LIST))) {
            result = new ArrayList<Value>();
        }
        return result;
    }

    @Override
    public Set<Vertex> getVertexSet(URI predicate) {
        Set<Edge> set = this.outProperty(predicate);
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Vertex> result = new HashSet<Vertex>();
        for (Edge e : set) {
            Value object = e.getObject();
            if (!(object instanceof Resource)) continue;
            Vertex v = this.graph.getVertex((Resource)object);
            if (v == null) {
                throw new KonigException("Vertex not found for resource: " + object.stringValue());
            }
            result.add(v);
        }
        return result;
    }

    @Override
    public Value getValue(URI predicate) throws KonigException {
        Set<Edge> set = this.outProperty(predicate);
        if (set == null || set.isEmpty()) {
            return null;
        }
        Iterator<Edge> sequence = set.iterator();
        return sequence.next().getObject();
    }

    @Override
    public boolean hasProperty(URI predicate, Value value) {
        Set<Edge> set = this.outProperty(predicate);
        for (Edge e : set) {
            if (!value.equals(e.getObject())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addProperty(URI property, Value value) {
        this.graph.add(new EdgeImpl(this.id, property, value));
    }

    @Override
    public Integer integerValue(URI predicate) {
        Value value = this.getValue(predicate);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value.stringValue()));
    }

    @Override
    public String stringValue(URI predicate) {
        Value value = this.getValue(predicate);
        return value == null ? null : value.stringValue();
    }

    @Override
    public Double doubleValue(URI predicate) {
        Value value = this.getValue(predicate);
        return value == null ? null : Double.valueOf(Double.parseDouble(value.stringValue()));
    }

    @Override
    public Vertex vertexValue(URI predicate) {
        Value value = this.getValue(predicate);
        return value instanceof Resource ? this.graph.vertex((Resource)value) : null;
    }

    @Override
    public boolean isOrphan() {
        Set<Map.Entry<URI, Set<Edge>>> set = this.inEdges();
        for (Map.Entry<URI, Set<Edge>> entry : set) {
            Set<Edge> s = entry.getValue();
            if (s.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Vertex getVertex(URI predicate) throws KonigException {
        Value value = this.getValue(predicate);
        return value instanceof Resource ? this.graph.getVertex((Resource)value) : null;
    }

    @Override
    public URI getURI(URI predicate) {
        Set<Edge> set = this.outProperty(predicate);
        if (set == null || set.isEmpty()) {
            return null;
        }
        for (Edge edge : set) {
            Value value = edge.getObject();
            if (!(value instanceof URI)) continue;
            return (URI)value;
        }
        return null;
    }

    @Override
    public Set<Value> getValueSet(URI predicate) {
        Set<Edge> edgeSet = this.outProperty(predicate);
        LinkedHashSet<Value> result = new LinkedHashSet<Value>();
        for (Edge e : edgeSet) {
            result.add(e.getObject());
        }
        return result;
    }

    @Override
    public Resource getResource(URI predicate) {
        Set<Edge> set = this.outProperty(predicate);
        if (set == null || set.isEmpty()) {
            return null;
        }
        for (Edge edge : set) {
            Value value = edge.getObject();
            if (!(value instanceof Resource)) continue;
            return (Resource)value;
        }
        return null;
    }

    @Override
    public boolean isList() {
        return !this.outProperty(RDF.FIRST).isEmpty();
    }
}

