/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import io.konig.core.Context;
import io.konig.core.ContextManager;
import io.konig.core.Term;
import io.konig.core.impl.KonigLiteral;
import io.konig.core.io.KonigReadException;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.URIImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGraphReader {
    private static final Logger logger = LoggerFactory.getLogger(BaseGraphReader.class);
    protected Context context;
    private ByteBuffer data;
    private Resource subject;
    private URI predicate;
    private Value object;
    protected Term qnameTerm;
    protected Term term;

    protected void read(byte[] data, ContextManager manager) throws KonigReadException {
        this.data = ByteBuffer.wrap(data);
        short version = this.readVersion();
        if (version != 1) {
            throw new KonigReadException("Unsupported version " + version);
        }
        long contextVersion = this.data.getLong();
        this.context = manager.getContextByVersionNumber(contextVersion);
        if (this.context == null) {
            throw new KonigReadException("Context not found: " + contextVersion);
        }
        this.context.compile();
        this.startRDF();
        this.handleContext(this.context);
        this.readVertices();
        this.endRDF();
    }

    protected void startRDF() {
    }

    protected void handleContext(Context context) {
    }

    protected void beginSubject(Resource subject, Term qname, Term idTerm) {
    }

    protected void endSubject() {
    }

    protected void startPredicate(URI predicate, Term term, Term qnameTerm, int objectCount) {
    }

    protected void endPredicate(URI predicate, int objectCount) {
    }

    protected void handleObject(Value value, Term term, Term qnameTerm) {
    }

    protected void handleStatement(Resource subject, URI predicate, Value object) {
    }

    protected void endRDF() {
    }

    private void readVertices() {
        while (this.peekToken() != 0) {
            this.subject = this.readResource();
            this.beginSubject(this.subject, this.term, this.qnameTerm);
            this.qnameTerm = null;
            this.term = null;
            this.readProperties();
            this.readNamedGraph();
            this.endSubject();
        }
    }

    protected Object beginNamedGraph(Resource subject) {
        return null;
    }

    protected void endNamedGraph(Object state) {
    }

    private void readNamedGraph() {
        byte token = this.peekToken();
        if (token == 11) {
            this.data.get();
            Resource oldSubject = this.subject;
            Object oldState = this.beginNamedGraph(this.subject);
            int count = this.data.getShort();
            logger.debug("READ: GRAPH {} count={}", (Object)this.subject.stringValue(), (Object)((short)count));
            for (int i = 0; i < count; ++i) {
                this.subject = this.readResource();
                this.beginSubject(this.subject, this.term, this.qnameTerm);
                this.qnameTerm = null;
                this.term = null;
                this.readProperties();
                this.readNamedGraph();
                this.endSubject();
            }
            this.subject = oldSubject;
            this.endNamedGraph(oldState);
        }
    }

    private Resource readResource() {
        byte token = this.peekToken();
        switch (token) {
            case 1: 
            case 2: 
            case 3: {
                return this.readIRI();
            }
            case 4: {
                return this.readBNode();
            }
        }
        throw new KonigReadException("Invalid token for Resource: " + token);
    }

    private void readProperties() {
        int count = this.data.getShort();
        for (int i = 0; i < count; ++i) {
            this.predicate = this.readIRI();
            this.readObjects();
        }
    }

    private void readObjects() {
        int count = this.data.getShort();
        this.startPredicate(this.predicate, this.term, this.qnameTerm, count);
        this.qnameTerm = null;
        this.term = null;
        for (int i = 0; i < count; ++i) {
            this.object = this.readObject();
            this.handleObject(this.object, this.term, this.qnameTerm);
            this.qnameTerm = null;
            this.term = null;
            logger.debug("READ: {} {} {}", new Object[]{this.subject, this.predicate, this.object});
            this.handleStatement(this.subject, this.predicate, this.object);
        }
        this.endPredicate(this.predicate, count);
    }

    private Value readObject() {
        byte token = this.peekToken();
        switch (token) {
            case 1: 
            case 2: 
            case 3: {
                return this.readIRI();
            }
            case 5: {
                return this.resourceReference();
            }
            case 4: {
                return this.readBNode();
            }
            case 10: {
                return this.readPlainLiteral();
            }
            case 9: {
                return this.readLanguageLiteral();
            }
            case 6: {
                return this.readTermLiteral();
            }
            case 7: {
                return this.readQNameLiteral();
            }
            case 8: {
                return this.readIRILiteral();
            }
        }
        throw new KonigReadException("Invalid token for object " + token);
    }

    private Value readIRILiteral() {
        this.assertToken((byte)8);
        return new URIImpl(this.readString());
    }

    private Value readQNameLiteral() {
        this.assertToken((byte)7);
        return this.qname();
    }

    private URI qname() {
        List<Term> list;
        short index = this.data.getShort();
        if (index >= (list = this.context.asList()).size()) {
            throw new KonigReadException("Index for term in context out of range");
        }
        this.qnameTerm = list.get(index);
        String namespaceValue = null;
        URI namespace = this.qnameTerm.getExpandedId();
        if (namespace != null) {
            namespaceValue = namespace.stringValue();
        } else {
            namespaceValue = this.qnameTerm.getId();
            if (namespaceValue == null) {
                throw new KonigReadException("Namespace not found for term " + this.qnameTerm.getKey());
            }
        }
        String localName = this.readString();
        return new URIImpl(namespaceValue + localName);
    }

    private Value readTermLiteral() {
        this.assertToken((byte)6);
        URI type = this.term();
        String value = this.readString();
        return new KonigLiteral(value, type);
    }

    private Value readLanguageLiteral() {
        this.assertToken((byte)9);
        String language = this.readString();
        String text = this.readString();
        return new KonigLiteral(text, language);
    }

    private Value readPlainLiteral() {
        this.assertToken((byte)10);
        String text = this.readString();
        return new KonigLiteral(text);
    }

    private Resource resourceReference() {
        this.assertToken((byte)5);
        int position = this.data.getInt();
        int mark = this.data.position();
        this.data.position(position);
        Resource result = this.readResource();
        this.data.position(mark);
        return result;
    }

    private void assertToken(byte expected) {
        byte token = this.data.get();
        if (token != expected) {
            throw new KonigReadException("Expected token " + expected + " but found " + token);
        }
    }

    private BNode readBNode() {
        this.assertToken((byte)4);
        short bnodeId = this.data.getShort();
        return new BNodeImpl("x" + bnodeId);
    }

    private URI readIRI() {
        byte token = this.peekToken();
        switch (token) {
            case 1: {
                return this.readTerm();
            }
            case 2: {
                return this.readQName();
            }
            case 3: {
                return this.absoluteIRI();
            }
        }
        throw new KonigReadException("Invalid IRI token: " + token);
    }

    private URI absoluteIRI() {
        this.assertToken((byte)3);
        return new URIImpl(this.readString());
    }

    private URI readQName() {
        this.assertToken((byte)2);
        return this.qname();
    }

    private URI readTerm() {
        this.assertToken((byte)1);
        return this.term();
    }

    private URI term() {
        List<Term> list;
        short index = this.data.getShort();
        if (index >= (list = this.context.asList()).size()) {
            throw new KonigReadException("Index for term in context out of range");
        }
        this.term = list.get(index);
        URI result = this.term.getExpandedId();
        if (result == null) {
            String id = this.term.getId();
            if (id == null) {
                throw new KonigReadException("Expanded value for term not found: " + this.term.getKey());
            }
            result = new URIImpl(id);
        }
        return result;
    }

    private byte peekToken() {
        if (!this.data.hasRemaining()) {
            return 0;
        }
        int mark = this.data.position();
        byte token = this.data.get();
        this.data.position(mark);
        return token;
    }

    private String readString() {
        byte b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (this.data.hasRemaining() && (b = this.data.get()) != 0) {
            out.write(b);
        }
        return new String(out.toByteArray());
    }

    private short readVersion() {
        return this.data.getShort();
    }
}

