/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class BaseParser {
    protected PushbackReader reader;
    protected StringBuilder buffer = new StringBuilder();
    private String baseURI;
    private int lineNumber = 1;
    private int columnNumber;

    protected BaseParser(Reader reader, int maxBuffer) {
        this.reader = new PushbackReader(reader, maxBuffer);
    }

    protected StringBuilder buffer() {
        this.buffer.setLength(0);
        return this.buffer;
    }

    protected int read() throws IOException {
        if (this.reader == null) {
            return -1;
        }
        int next = this.reader.read();
        if (next == -1) {
            this.reader = null;
            return -1;
        }
        ++this.columnNumber;
        if (Character.isHighSurrogate((char)next)) {
            next = Character.toCodePoint((char)next, (char)this.reader.read());
            ++this.columnNumber;
        }
        if (next == 10) {
            ++this.lineNumber;
            this.columnNumber = 0;
        }
        return next;
    }

    protected boolean skipSpace() throws IOException {
        boolean result = false;
        int c = this.read();
        while (this.isWhitespace(c)) {
            result = true;
            c = this.read();
        }
        this.unread(c);
        return result;
    }

    protected boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10;
    }

    protected void unread(int codePoint) throws IOException {
        if (codePoint != -1) {
            if (Character.isSupplementaryCodePoint(codePoint)) {
                char[] surrogatePair = Character.toChars(codePoint);
                this.reader.unread(surrogatePair);
                this.columnNumber -= 2;
            } else {
                if (codePoint == 10) {
                    --this.lineNumber;
                    this.columnNumber = Integer.MIN_VALUE;
                } else {
                    --this.columnNumber;
                }
                this.reader.unread(codePoint);
            }
        }
    }

    protected int peek() throws IOException {
        int c = this.read();
        this.unread(c);
        return c;
    }
}

