/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import io.konig.core.Context;
import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Term;
import io.konig.core.Vertex;
import io.konig.core.io.GraphWriter;
import io.konig.core.io.KonigWriteException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryGraphWriter {
    private static final Logger logger = LoggerFactory.getLogger(BinaryGraphWriter.class);
    Graph graph;
    Context context;
    Context inverse;
    ByteArrayOutputStream out;
    DataOutputStream data;
    short bnodeCount = 1;
    private Map<String, Short> bnodeMap = new HashMap<String, Short>();
    private PromiseInfo promiseInfo;
    private List<PromiseInfo> promiseInfoList = new ArrayList<PromiseInfo>();

    public byte[] write(Graph source, Context context) throws KonigWriteException {
        this.graph = source;
        this.context = context;
        long contextVersion = context.getVersionNumber();
        if (contextVersion < 1L) {
            throw new KonigWriteException("JSON-LD context version number is not defined");
        }
        this.inverse = context.inverse();
        this.promiseInfo = new PromiseInfo();
        this.promiseInfoList.add(this.promiseInfo);
        this.out = new ByteArrayOutputStream();
        this.data = new DataOutputStream(this.out);
        try {
            this.data.writeShort(1);
            this.data.writeLong(contextVersion);
            Collection<Vertex> list = this.graph.vertices();
            for (Vertex v : list) {
                this.writeVertex(v);
            }
            this.data.flush();
        }
        catch (IOException e) {
            throw new KonigWriteException(e);
        }
        byte[] array = this.out.toByteArray();
        this.deliverPromises(array);
        return array;
    }

    private void writeVertex(Vertex v) throws IOException {
        Resource id = v.getId();
        Term term = this.inverse.getTerm(id.stringValue());
        Set<Map.Entry<URI, Set<Edge>>> set = v.outEdges();
        if (term != null && term != null && set.isEmpty()) {
            return;
        }
        int position = this.out.size();
        this.promiseInfo.putSubject(id.stringValue(), new Integer(position));
        if (id instanceof URI) {
            this.writeIRI((URI)id, term);
        } else {
            this.writeBNode((BNode)id);
        }
        this.data.writeShort(set.size());
        for (Map.Entry<URI, Set<Edge>> e : set) {
            URI predicate = e.getKey();
            this.writePredicateIRI(predicate);
            Set<Edge> value = e.getValue();
            this.data.writeShort(value.size());
            for (Edge edge : value) {
                logger.debug("WRITE: {} {} {}", new Object[]{id.stringValue(), edge.getPredicate().stringValue(), edge.getObject().stringValue()});
                this.writeObject(edge.getObject());
            }
        }
        Graph namedGraph = v.asNamedGraph();
        if (namedGraph != null) {
            logger.debug("WRITE: GRAPH {}", (Object)id.stringValue());
            PromiseInfo oldInfo = this.promiseInfo;
            this.promiseInfo = new PromiseInfo();
            this.promiseInfoList.add(this.promiseInfo);
            Collection<Vertex> list = namedGraph.vertices();
            short size = (short)list.size();
            this.data.writeByte(11);
            this.data.writeShort(size);
            for (Vertex vertex : list) {
                this.writeVertex(vertex);
            }
            this.promiseInfo = oldInfo;
        }
    }

    private void writeObject(Value object) throws IOException {
        if (object instanceof URI) {
            this.writeObjectIRI((URI)object);
        } else if (object instanceof BNode) {
            this.writeBNode((BNode)object);
        } else {
            this.writeLiteral((Literal)object);
        }
    }

    private void writeLiteral(Literal object) throws IOException {
        URI type = object.getDatatype();
        String language = object.getLanguage();
        String value = object.stringValue();
        if (language != null) {
            this.data.writeByte(9);
        } else if (type != null) {
            Term term = this.inverse.getTerm(type.stringValue());
            if (term != null) {
                this.data.writeByte(6);
                this.data.writeShort(term.getIndex());
            } else {
                String namespace = type.getNamespace();
                term = this.inverse.getTerm(namespace);
                if (term != null) {
                    this.data.writeByte(7);
                    this.data.writeShort(term.getIndex());
                    this.writeString(type.getLocalName());
                } else {
                    this.data.writeByte(8);
                    this.writeString(type.stringValue());
                }
            }
        } else {
            this.data.writeByte(10);
        }
        this.writeString(value);
    }

    private void writeObjectIRI(URI object) throws IOException {
        Term term = this.inverse.getTerm(object.stringValue());
        if (term != null) {
            this.data.writeByte(1);
            this.data.writeShort(term.getIndex());
        } else {
            Integer position = this.promiseInfo.subjectMap.get(object.stringValue());
            this.data.writeByte(5);
            if (position == null) {
                int mark = this.out.size();
                this.promiseInfo.addPromise(mark, (Resource)object);
                this.data.writeInt(0);
            } else {
                this.data.writeInt(position);
            }
        }
    }

    private void writePredicateIRI(URI predicate) throws IOException {
        Term term = this.inverse.getTerm(predicate.stringValue());
        this.writeIRI(predicate, term);
    }

    private void writeBNode(BNode id) throws IOException {
        this.data.writeByte(4);
        this.data.writeShort(this.shortBNode(id));
    }

    private short shortBNode(BNode bnode) {
        Short id = this.bnodeMap.get(bnode.getID());
        if (id == null) {
            this.bnodeCount = (short)(this.bnodeCount + 1);
            id = new Short(this.bnodeCount);
            this.bnodeMap.put(bnode.getID(), id);
        }
        return id;
    }

    private void writeIRI(URI id, Term term) throws IOException {
        if (term != null) {
            this.data.writeByte(1);
            this.data.writeShort(term.getIndex());
        } else {
            String namespace = id.getNamespace();
            term = this.inverse.getTerm(namespace);
            if (term != null) {
                this.data.writeByte(2);
                this.data.writeShort(term.getIndex());
                this.writeString(id.getLocalName());
            } else {
                this.data.writeByte(3);
                this.writeString(id.stringValue());
            }
        }
    }

    private void writeString(String value) throws IOException {
        if (value == null) {
            value = "";
        }
        byte[] array = value.getBytes();
        this.data.write(array);
        this.data.writeByte(0);
    }

    private void deliverPromises(byte[] array) {
        for (PromiseInfo info : this.promiseInfoList) {
            info.deliverPromises(array);
        }
    }

    static class PromiseInfo {
        Map<String, Integer> subjectMap = new HashMap<String, Integer>();
        Map<String, List<GraphWriter.Promise>> promiseMap = new HashMap<String, List<GraphWriter.Promise>>();

        PromiseInfo() {
        }

        private void putSubject(String resource, Integer index) {
            this.subjectMap.put(resource, index);
        }

        private void addPromise(int mark, Resource target) {
            GraphWriter.Promise promise = new GraphWriter.Promise(target, mark);
            String key = target.stringValue();
            List<GraphWriter.Promise> list = this.promiseMap.get(key);
            if (list == null) {
                list = new ArrayList<GraphWriter.Promise>();
                this.promiseMap.put(key, list);
            }
            list.add(promise);
        }

        private void deliverPromises(byte[] array) {
            ByteBuffer buffer = ByteBuffer.wrap(array);
            for (Map.Entry<String, List<GraphWriter.Promise>> e : this.promiseMap.entrySet()) {
                String resourceKey = e.getKey();
                Integer position = this.subjectMap.get(resourceKey);
                List<GraphWriter.Promise> list = e.getValue();
                for (GraphWriter.Promise promise : list) {
                    buffer.position(promise.mark);
                    buffer.putInt(position);
                }
            }
        }
    }
}

