/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import info.aduna.io.IndentingWriter;
import io.konig.core.io.TurtleConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.util.Literals;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.turtle.TurtleUtil;
import org.openrdf.rio.turtle.TurtleWriter;

public class CompactTurtleWriter
extends TurtleWriter {
    private List<Context> stack = new ArrayList<Context>();
    private String baseIRI = null;
    private TurtleConfig config = new TurtleConfig();
    private boolean emitBase = false;

    public TurtleConfig getConfig() {
        return this.config;
    }

    public void setConfig(TurtleConfig config) {
        this.config = config;
    }

    public String getBaseIRI() {
        return this.baseIRI;
    }

    public void setBaseIRI(String baseIRI) {
        this.baseIRI = baseIRI;
    }

    public CompactTurtleWriter(OutputStream out) {
        super(out);
        this.stack.add(new Context());
    }

    public CompactTurtleWriter(Writer writer) {
        super(writer);
        this.stack.add(new Context());
    }

    public void startRDF() throws RDFHandlerException {
        if (this.config.getBaseDirectiveHandler() != null) {
            this.emitBase = true;
        }
        if (this.baseIRI != null) {
            try {
                this.writer.write("@base ");
                this.writer.write(60);
                this.writer.write(this.baseIRI);
                this.writer.write("> .");
                this.writer.writeEOL();
            }
            catch (IOException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }
        super.startRDF();
    }

    protected void writeURI(URI uri) throws IOException {
        if (this.emitBase) {
            String newBase = this.config.getBaseDirectiveHandler().injectBaseDirective(uri);
            if (newBase != null) {
                this.baseIRI = newBase;
                this.writer.write("@base <");
                this.writer.write(this.baseIRI);
                this.writer.write("> .");
                this.writer.writeEOL();
            }
            this.emitBase = false;
        }
        String uriString = uri.toString();
        String namespaceName = uri.getNamespace();
        String localName = uri.getLocalName();
        String prefix = (String)this.namespaceTable.get(namespaceName);
        if (prefix == null && (prefix = (String)this.namespaceTable.get(uriString)) != null) {
            localName = "";
        }
        if (this.useCurie(prefix, localName)) {
            this.writer.write(prefix);
            this.writer.write(":");
            this.writer.write(localName);
        } else if (this.baseIRI != null && uriString.startsWith(this.baseIRI)) {
            this.writer.write(60);
            this.writer.write(TurtleUtil.encodeURIString((String)uriString.substring(this.baseIRI.length())));
            this.writer.write(62);
        } else {
            this.writer.write("<");
            this.writer.write(TurtleUtil.encodeURIString((String)uriString));
            this.writer.write(">");
        }
    }

    private boolean useCurie(String prefix, String localName) {
        if (prefix != null && localName != null) {
            if (localName.length() == 0) {
                return true;
            }
            char c = localName.charAt(0);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') {
                for (int i = 1; i < localName.length(); ++i) {
                    if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '-' || c == '_') continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        Resource subject = st.getSubject();
        URI predicate = st.getPredicate();
        Value object = st.getObject();
        Context context = this.peek();
        try {
            if (RDF.FIRST.equals((Object)predicate) || RDF.REST.equals((Object)predicate)) {
                ListInfo listInfo = context.listInfo;
                boolean startList = false;
                if (listInfo == null) {
                    this.writer.write("(");
                    context.listInfo = listInfo = new ListInfo();
                    startList = true;
                }
                if (RDF.FIRST.equals((Object)predicate)) {
                    listInfo.first = object;
                    if (!startList) {
                        this.writer.write(" ");
                    }
                    if (object instanceof BNode) {
                        this.writer.write(" [ ");
                        this.writer.increaseIndentation();
                        this.writer.writeEOL();
                        Context next = new Context();
                        next.lastSubject = this.lastWrittenSubject = (BNode)object;
                        this.stack.add(next);
                    } else {
                        this.writeValue(object);
                    }
                } else if (RDF.REST.equals((Object)predicate)) {
                    listInfo.rest = (Resource)object;
                }
                if (listInfo.first != null && listInfo.rest != null && RDF.NIL.equals((Object)listInfo.rest)) {
                    this.writer.write(")");
                    context.listInfo = null;
                    this.stack.remove(this.stack.size() - 1);
                }
                return;
            }
            if (context.bracket != null) {
                this.writer.write(context.bracket);
                this.writer.increaseIndentation();
                this.writer.writeEOL();
                context.bracket = null;
            }
            if (context.lastSubject instanceof BNode && !subject.equals(context.lastSubject)) {
                context = this.closeBNode(st);
            }
            if (subject.equals(context.lastSubject)) {
                if (predicate.equals((Object)context.lastPredicate)) {
                    this.writer.write(" , ");
                } else {
                    if (context.lastPredicate != null) {
                        this.writer.write(" ; ");
                        this.writer.writeEOL();
                    }
                    this.writePredicate(predicate);
                    this.writer.write(32);
                    context.lastPredicate = this.lastWrittenPredicate = predicate;
                }
            } else {
                if (this.stack.size() == 1 && context.lastSubject != null) {
                    this.writer.write(" . ");
                    this.writer.writeEOL();
                    this.writer.decreaseIndentation();
                    if (this.config.getBaseDirectiveHandler() != null) {
                        this.emitBase = true;
                    }
                }
                this.writer.writeEOL();
                this.writeResource(subject);
                this.writer.write(32);
                context.lastSubject = this.lastWrittenSubject = subject;
                this.writePredicate(predicate);
                this.writer.write(32);
                context.lastPredicate = this.lastWrittenPredicate = predicate;
                this.writer.increaseIndentation();
            }
            if (object instanceof BNode) {
                Context next = new Context();
                next.bracket = " [ ";
                next.lastSubject = this.lastWrittenSubject = (BNode)object;
                this.stack.add(next);
            } else {
                this.writeValue(object);
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    protected void writeResource(Resource res) throws IOException {
        if (res instanceof URI) {
            this.writeURI((URI)res);
        } else {
            this.writer.write("[]");
        }
    }

    protected void writeLiteral(Literal lit) throws IOException {
        URI type = lit.getDatatype();
        if (XMLSchema.INT.equals((Object)type)) {
            this.writer.write(lit.getLabel());
        } else {
            String label = lit.getLabel();
            URI datatype = lit.getDatatype();
            if (XMLSchema.INTEGER.equals((Object)datatype) || XMLSchema.DECIMAL.equals((Object)datatype) || XMLSchema.DOUBLE.equals((Object)datatype) || XMLSchema.BOOLEAN.equals((Object)datatype)) {
                try {
                    this.writer.write(XMLDatatypeUtil.normalize((String)label, (URI)datatype));
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (label.indexOf(10) != -1 || label.indexOf(13) != -1 || label.indexOf(9) != -1) {
                this.writeLongString(this.writer, label);
            } else {
                this.writer.write("\"");
                this.encodeString(label);
                this.writer.write("\"");
            }
            if (Literals.isLanguageLiteral((Literal)lit)) {
                this.writer.write("@");
                this.writer.write(lit.getLanguage());
            } else if (!XMLSchema.STRING.equals((Object)datatype) && datatype != null) {
                this.writer.write("^^");
                this.writeURI(datatype);
            }
        }
    }

    private void encodeString(String label) throws IOException {
        int c;
        block7: for (int i = 0; i < label.length(); i += Character.charCount(c)) {
            c = label.codePointAt(i);
            switch (c) {
                case 92: {
                    this.writer.write("\\\\");
                    continue block7;
                }
                case 9: {
                    this.writer.write("\\t");
                    continue block7;
                }
                case 10: {
                    this.writer.write("\\n");
                    continue block7;
                }
                case 13: {
                    this.writer.write("\\r");
                    continue block7;
                }
                case 34: {
                    this.writer.write("\\\"");
                    continue block7;
                }
                default: {
                    int k;
                    String hexValue;
                    if ((c < 32 || c > 255) && c < 65535) {
                        hexValue = Integer.toHexString(c);
                        this.writer.write("\\u");
                        for (k = hexValue.length(); k < 4; ++k) {
                            this.writer.write(48);
                        }
                        this.writer.write(hexValue);
                        continue block7;
                    }
                    if (c >= 65535) {
                        hexValue = Integer.toHexString(c);
                        this.writer.write("\\U");
                        for (k = hexValue.length(); k < 8; ++k) {
                            this.writer.write(48);
                        }
                        this.writer.write(hexValue);
                        continue block7;
                    }
                    this.writer.write((int)((char)c));
                }
            }
        }
    }

    private void writeLongString(IndentingWriter writer, String s) throws IOException {
        boolean singleQuote;
        boolean bl = singleQuote = s.indexOf(39) == -1;
        if (singleQuote) {
            writer.write("'''");
            this.encodeLongString(s, '\'', "\\'");
            writer.write("'''");
        } else {
            writer.write("\"\"\"");
            this.encodeLongString(s, '\"', "\\\"");
            writer.write("\"\"\"");
        }
    }

    private void encodeLongString(String label, char quoteChar, String quoteString) throws IOException {
        int c;
        for (int i = 0; i < label.length(); i += Character.charCount(c)) {
            int k;
            String hexValue;
            c = label.codePointAt(i);
            if (c == quoteChar || c == 10 || c == 13) {
                this.writer.write(c);
                continue;
            }
            if ((c < 32 || c > 255) && c < 65535) {
                hexValue = Integer.toHexString(c);
                this.writer.write("\\u");
                for (k = hexValue.length(); k < 4; ++k) {
                    this.writer.write(48);
                }
                this.writer.write(hexValue);
                continue;
            }
            if (c >= 65535) {
                hexValue = Integer.toHexString(c);
                this.writer.write("\\U");
                for (k = hexValue.length(); k < 8; ++k) {
                    this.writer.write(48);
                }
                this.writer.write(hexValue);
                continue;
            }
            this.writer.write((int)((char)c));
        }
    }

    private Context closeBNode(Statement s) throws IOException {
        Context context = null;
        Resource subject = s.getSubject();
        boolean nextIsBNode = s.getObject() instanceof BNode;
        while (this.stack.size() > 1) {
            this.writer.decreaseIndentation();
            if (nextIsBNode) {
                this.writer.writeEOL();
            }
            this.writer.write(" ] ");
            this.stack.remove(this.stack.size() - 1);
            context = this.peek();
            this.lastWrittenSubject = context.lastSubject;
            this.lastWrittenPredicate = context.lastPredicate;
            if (!subject.equals(context.lastSubject)) continue;
        }
        if (context == null) {
            context = this.peek();
        }
        return context;
    }

    public void endRDF() throws RDFHandlerException {
        try {
            while (this.stack.size() > 1) {
                this.writer.write(" ] ");
                this.stack.remove(this.stack.size() - 1);
            }
            this.writer.write(" . ");
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private Context peek() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.stack.get(this.stack.size() - 1);
    }

    private static class Context {
        String bracket;
        Resource lastSubject;
        URI lastPredicate;
        ListInfo listInfo;

        private Context() {
        }
    }

    private static class ListInfo {
        Value first;
        Resource rest;

        private ListInfo() {
        }
    }
}

