/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import java.util.ArrayList;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class CompositeRdfHandler
extends ArrayList<RDFHandler>
implements RDFHandler {
    private static final long serialVersionUID = 1L;

    public CompositeRdfHandler() {
    }

    public CompositeRdfHandler(RDFHandler ... handlers) {
        for (RDFHandler h : handlers) {
            this.add(h);
        }
    }

    public void startRDF() throws RDFHandlerException {
        for (RDFHandler child : this) {
            child.startRDF();
        }
    }

    public void endRDF() throws RDFHandlerException {
        for (RDFHandler child : this) {
            child.endRDF();
        }
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        for (RDFHandler child : this) {
            child.handleNamespace(prefix, uri);
        }
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        for (RDFHandler child : this) {
            child.handleStatement(st);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        for (RDFHandler child : this) {
            child.handleComment(comment);
        }
    }
}

