/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.konig.core.Context;
import io.konig.core.ContextManager;
import io.konig.core.Term;
import io.konig.core.impl.BasicContext;
import io.konig.core.impl.CompositeContext;
import io.konig.core.io.KonigReadException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class ContextReader {
    private ContextManager contextManager;

    public ContextReader() {
    }

    public ContextReader(ContextManager contextManager) {
        this.contextManager = contextManager;
    }

    public Context parse(ObjectNode node) throws KonigReadException {
        return this.parseObject(node, false);
    }

    public Context read(InputStream input) throws KonigReadException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(input);
            if (node instanceof ObjectNode) {
                JsonNode mimeType;
                ObjectNode object = (ObjectNode)node;
                Context context = this.parseObject(object, true);
                if (context != null && (mimeType = object.get("vendorType")) != null) {
                    String vendorType = mimeType.textValue();
                    context.setVendorType(vendorType);
                }
                return context;
            }
        }
        catch (IOException e) {
            throw new KonigReadException(e);
        }
        throw new KonigReadException("Root node in stream is not a JSON object");
    }

    private Context parseArray(ArrayNode array) throws KonigReadException {
        CompositeContext composite = new CompositeContext();
        for (int i = 0; i < array.size(); ++i) {
            Context context;
            JsonNode node = array.get(i);
            if (node.isTextual()) {
                String contextIRI = node.asText();
                if (this.contextManager == null) {
                    throw new KonigReadException("Cannot load context because manager is not defined: " + contextIRI);
                }
                context = this.contextManager.getContextByURI(contextIRI);
                if (context == null) {
                    throw new KonigReadException("Context not found: " + contextIRI);
                }
                composite.append(context);
                continue;
            }
            if (!(node instanceof ObjectNode)) continue;
            ObjectNode terms = (ObjectNode)node;
            context = new BasicContext(null);
            this.parseTerms(terms, context);
            composite.append(context);
        }
        return composite;
    }

    private void parseTerms(ObjectNode terms, Context context) {
        Iterator sequence = terms.fieldNames();
        while (sequence.hasNext()) {
            String key = (String)sequence.next();
            JsonNode termNode = terms.get(key);
            String idValue = null;
            String language = null;
            String type = null;
            String container = null;
            Term term = null;
            if (termNode.isTextual()) {
                idValue = termNode.asText();
            } else if (termNode.isObject()) {
                ObjectNode termObject = (ObjectNode)termNode;
                idValue = this.stringValue(termObject, "@id");
                language = this.stringValue(termObject, "@language");
                type = this.stringValue(termObject, "@type");
                container = this.stringValue(termObject, "@container");
            }
            term = new Term(key, idValue, language, type, container);
            context.add(term);
        }
    }

    private Context parseObject(ObjectNode node, boolean useId) throws KonigReadException {
        JsonNode contextNode;
        Context context;
        JsonNode id;
        String contextIRI = null;
        if (useId && (id = node.get("@id")) != null) {
            contextIRI = id.asText();
            if (this.contextManager != null && (context = this.contextManager.getContextByURI(contextIRI)) != null) {
                return context;
            }
        }
        if ((contextNode = node.get("@context")) instanceof ArrayNode) {
            return this.parseArray((ArrayNode)contextNode);
        }
        context = null;
        if (contextNode.isTextual()) {
            contextIRI = contextNode.asText();
            if (this.contextManager != null) {
                context = this.contextManager.getContextByURI(contextIRI);
            }
            if (context == null) {
                throw new KonigReadException("Context not found: " + contextIRI);
            }
            return context;
        }
        context = new BasicContext(contextIRI);
        if (this.contextManager != null && contextIRI != null) {
            this.contextManager.add(context);
        }
        if (contextNode instanceof ObjectNode) {
            this.parseTerms((ObjectNode)contextNode, context);
        }
        return context;
    }

    private String stringValue(ObjectNode node, String key) {
        JsonNode value = node.get(key);
        if (value != null && value.isTextual()) {
            return value.asText();
        }
        return null;
    }
}

