/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import io.konig.core.Context;
import io.konig.core.ContextManager;
import io.konig.core.Term;
import io.konig.core.io.GraphConstants;
import io.konig.core.io.KonigReadException;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.openrdf.model.URI;

public class DebugGraphReader {
    private static final char newline = '\n';
    private ByteBuffer data;
    private Context context;
    private StringBuilder builder;

    public String toDebugString(byte[] array, ContextManager manager) {
        this.data = ByteBuffer.wrap(array);
        this.builder = new StringBuilder();
        short version = this.data.getShort();
        this.builder.append("0 VERSION ").append(version).append('\n');
        this.mark();
        String contextURI = this.readString();
        this.append("CONTEXT ").append(contextURI).append('\n');
        this.context = manager.getContextByURI(contextURI);
        if (this.context == null) {
            throw new KonigReadException("Context not found: " + contextURI);
        }
        this.context.compile();
        this.appendVertices();
        return this.builder.toString();
    }

    private void appendVertices() {
        List<Term> termList = this.context.asList();
        while (this.data.hasRemaining()) {
            this.mark();
            byte token = this.data.get();
            switch (token) {
                case 3: {
                    String iriValue = this.readString();
                    this.append("<subject> IRI ").append(iriValue);
                    break;
                }
                case 1: {
                    short termIndex = this.data.getShort();
                    this.append("<subject> TERM[").append(termIndex).append("] ");
                    if (termIndex >= termList.size()) {
                        throw new KonigReadException("Term index out of range: " + termIndex);
                    }
                    Term term = termList.get(termIndex);
                    String termValue = this.context.expandIRI(term.getKey());
                    this.append(termValue);
                    break;
                }
                case 2: {
                    short qnameIndex = this.data.getShort();
                    this.append("<subject> QNAME[").append(qnameIndex).append("] ");
                    if (qnameIndex >= termList.size()) {
                        throw new KonigReadException("QNAME index out of range: " + qnameIndex);
                    }
                    Term prefixTerm = termList.get(qnameIndex);
                    URI prefixURI = prefixTerm.getExpandedId();
                    String prefixValue = prefixURI == null ? "null" : prefixURI.stringValue();
                    String localName = this.readString();
                    this.append(prefixValue).append(' ').append(localName);
                    break;
                }
                case 4: {
                    short bnodeId = this.data.getShort();
                    this.append("<subject> BNode[").append(bnodeId).append("]");
                    break;
                }
                default: {
                    this.invalidToken("Invalid token for subject: ", token);
                }
            }
            int predicateCount = this.data.getShort();
            this.append("; PREDICATE-COUNT: ").append(predicateCount).append('\n');
            for (int i = 0; i < predicateCount; ++i) {
                this.appendPredicate();
            }
            int position = this.data.position();
            token = this.peekToken();
            if (token != 11) continue;
            this.data.get();
            short graphSize = this.data.getShort();
            this.builder.append(position).append(" GRAPH; SIZE: ").append(graphSize).append('\n');
            this.appendVertices();
        }
    }

    private void invalidToken(String text, byte token) throws KonigReadException {
        text = token < GraphConstants.LABEL.length ? text + GraphConstants.LABEL[token] : text + token;
        throw new KonigReadException(text);
    }

    private void appendPredicate() {
        List<Term> termList = this.context.asList();
        this.mark();
        this.append("<predicate> ");
        byte token = this.data.get();
        switch (token) {
            case 3: {
                String iriValue = this.readString();
                this.append("IRI ").append(iriValue);
                break;
            }
            case 1: {
                short termIndex = this.data.getShort();
                if (termIndex >= termList.size()) {
                    throw new KonigReadException("Term index out of range: " + termIndex);
                }
                Term term = termList.get(termIndex);
                String termValue = this.context.expandIRI(term.getKey());
                this.append("TERM[").append(termIndex).append("] ");
                this.append(termValue);
                break;
            }
            case 2: {
                short qnameIndex = this.data.getShort();
                this.append("QNAME[").append(qnameIndex).append("] ");
                if (qnameIndex >= termList.size()) {
                    throw new KonigReadException("QNAME index out of range: " + qnameIndex);
                }
                Term prefixTerm = termList.get(qnameIndex);
                URI prefixURI = prefixTerm.getExpandedId();
                String prefixValue = prefixURI == null ? "null" : prefixURI.stringValue();
                String localName = this.readString();
                this.append(prefixValue).append(' ').append(localName);
                break;
            }
            default: {
                this.invalidToken("Invalid predicate token: ", token);
            }
        }
        int objectCount = this.data.getShort();
        this.append("; OBJECT-COUNT: ").append(objectCount).append('\n');
        for (int i = 0; i < objectCount; ++i) {
            this.appendObject();
        }
    }

    private void appendObject() {
        List<Term> termList = this.context.asList();
        this.mark();
        this.append("<object> ");
        byte token = this.data.get();
        switch (token) {
            case 5: {
                int position = this.data.getInt();
                this.append("RESOURCE; POSITION:").append(position);
                break;
            }
            case 4: {
                short bnodeId = this.data.getShort();
                this.append("BNode[").append(bnodeId).append(']');
                break;
            }
            case 1: {
                short termIndex = this.data.getShort();
                if (termIndex >= termList.size()) {
                    throw new KonigReadException("Term index out of range: " + termIndex);
                }
                Term term = termList.get(termIndex);
                String termValue = this.context.expandIRI(term.getKey());
                this.append("TERM[").append(termIndex).append("]; VALUE: ").append(termValue);
                break;
            }
            case 2: {
                short qnameIndex = this.data.getShort();
                this.append("QNAME[").append(qnameIndex).append("] ");
                if (qnameIndex >= termList.size()) {
                    throw new KonigReadException("QNAME index out of range: " + qnameIndex);
                }
                Term prefixTerm = termList.get(qnameIndex);
                URI prefixURI = prefixTerm.getExpandedId();
                String prefixValue = prefixURI == null ? "null" : prefixURI.stringValue();
                String localName = this.readString();
                this.append(prefixValue).append("; VALUE: ").append(localName);
                break;
            }
            case 10: {
                this.append("PLAIN; VALUE: ").append(this.readString());
                break;
            }
            case 6: {
                short termIndex = this.data.getShort();
                if (termIndex >= termList.size()) {
                    throw new KonigReadException("Term index out of range: " + termIndex);
                }
                Term term = termList.get(termIndex);
                String termValue = this.context.expandIRI(term.getKey());
                this.append("TYPE_TERM[").append(termIndex).append("] ").append(termValue);
                this.append("; VALUE: ").append(this.readString());
                break;
            }
            case 7: {
                short qnameIndex = this.data.getShort();
                this.append("TYPE_QNAME[").append(qnameIndex).append("] ");
                if (qnameIndex >= termList.size()) {
                    throw new KonigReadException("QNAME index out of range: " + qnameIndex);
                }
                Term prefixTerm = termList.get(qnameIndex);
                URI prefixURI = prefixTerm.getExpandedId();
                String prefixValue = prefixURI == null ? "null" : prefixURI.stringValue();
                String localName = this.readString();
                this.append(prefixValue).append(' ').append(localName);
                this.append("; VALUE: ").append(this.readString());
                break;
            }
            case 8: {
                this.append("TYPE_IRI ").append(this.readString()).append("; VALUE: ").append(this.readString());
                break;
            }
            case 9: {
                this.append("LANG ").append(this.readString()).append("; VALUE: ").append(this.readString());
                break;
            }
            default: {
                this.invalidToken("Invalid object token: ", token);
            }
        }
        this.builder.append('\n');
    }

    private StringBuilder append(String text) {
        return this.builder.append(text);
    }

    private StringBuilder mark() {
        return this.builder.append(this.data.position()).append(' ');
    }

    private String readString() {
        byte b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (this.data.hasRemaining() && (b = this.data.get()) != 0) {
            out.write(b);
        }
        return new String(out.toByteArray());
    }

    private byte peekToken() {
        if (!this.data.hasRemaining()) {
            return 0;
        }
        int mark = this.data.position();
        byte token = this.data.get();
        this.data.position(mark);
        return token;
    }
}

