/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.core.Context;
import io.konig.core.ContextManager;
import io.konig.core.Term;
import io.konig.core.io.BaseGraphReader;
import io.konig.core.io.KonigReadException;
import java.io.IOException;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class GraphBufferJsonWriter
extends BaseGraphReader {
    private JsonGenerator json;
    private boolean isIdField;
    private String predicateType;
    private String idKey;
    private String typeKey;
    private String valueKey;
    private String languageKey;

    public void write(byte[] data, ContextManager manager, JsonGenerator json) {
        this.json = json;
        this.read(data, manager);
    }

    @Override
    protected void startRDF() {
        try {
            this.json.writeStartObject();
        }
        catch (IOException e) {
            throw new KonigReadException(e);
        }
    }

    @Override
    protected void handleContext(Context context) {
        this.idKey = context.alias("@id");
        this.typeKey = context.alias("@type");
        this.valueKey = context.alias("@value");
        this.languageKey = context.alias("@language");
        try {
            this.json.writeStringField("@context", context.getContextIRI());
            this.json.writeArrayFieldStart("@graph");
        }
        catch (IOException e) {
            throw new KonigReadException(e);
        }
    }

    @Override
    protected void beginSubject(Resource subject, Term qnameTerm, Term idTerm) {
        try {
            String idValue = idTerm != null ? idTerm.getKey() : (qnameTerm != null && subject instanceof URI ? qnameTerm.getKey() + ":" + ((URI)subject).getLocalName() : (subject instanceof BNode ? "_:" + subject.stringValue() : subject.stringValue()));
            this.json.writeStartObject();
            this.json.writeStringField(this.idKey, idValue);
        }
        catch (IOException e) {
            throw new KonigReadException(e);
        }
    }

    @Override
    protected void endSubject() {
        try {
            this.json.writeEndObject();
        }
        catch (IOException e) {
            throw new KonigReadException(e);
        }
    }

    @Override
    protected void startPredicate(URI predicate, Term term, Term qnameTerm, int objectCount) {
        this.isIdField = term != null && term.getType().equals("@id");
        this.predicateType = null;
        if (term != null) {
            this.predicateType = term.getType();
        }
        String fieldName = predicate.stringValue();
        if (predicate.equals((Object)RDF.TYPE)) {
            fieldName = this.typeKey;
        } else if (term != null) {
            fieldName = term.getKey();
        } else if (qnameTerm != null) {
            fieldName = qnameTerm.getKey() + ":" + predicate.getLocalName();
        }
        try {
            this.json.writeFieldName(fieldName);
            if (objectCount > 1) {
                this.json.writeStartArray();
            }
        }
        catch (IOException e) {
            throw new KonigReadException(e);
        }
    }

    @Override
    protected void endPredicate(URI predicate, int objectCount) {
        if (objectCount > 1) {
            try {
                this.json.writeEndArray();
            }
            catch (IOException e) {
                throw new KonigReadException(e);
            }
        }
    }

    @Override
    protected void handleObject(Value value, Term term, Term qnameTerm) {
        try {
            if (value instanceof URI) {
                String text;
                URI iriValue = (URI)value;
                String string = term != null ? term.getKey() : (text = qnameTerm != null ? qnameTerm.getKey() + ":" + iriValue.getLocalName() : iriValue.stringValue());
                if (this.isIdField) {
                    this.json.writeString(text);
                } else {
                    this.json.writeStartObject();
                    this.json.writeStringField(this.idKey, text);
                    this.json.writeEndObject();
                }
            } else if (value instanceof BNode) {
                this.json.writeStartObject();
                this.json.writeStringField(this.idKey, "_:" + value.stringValue());
                this.json.writeEndObject();
            } else {
                Literal literal = (Literal)value;
                if (this.predicateType != null) {
                    this.json.writeString(value.stringValue());
                } else {
                    String language = literal.getLanguage();
                    URI type = literal.getDatatype();
                    this.json.writeStartObject();
                    this.json.writeStringField(this.valueKey, literal.stringValue());
                    if (language != null) {
                        this.json.writeStringField(this.languageKey, literal.getLanguage());
                    } else if (type != null) {
                        this.json.writeStringField(this.typeKey, type.stringValue());
                    }
                    this.json.writeEndObject();
                }
            }
        }
        catch (IOException e) {
            throw new KonigReadException(e);
        }
    }

    @Override
    protected void endRDF() {
        try {
            this.json.writeEndArray();
            this.json.writeEndObject();
        }
        catch (IOException e) {
            throw new KonigReadException(e);
        }
    }
}

