/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class GraphLoadHandler
extends RDFHandlerBase {
    private Graph graph;
    private URI quadContext;

    public GraphLoadHandler(Graph graph) {
        this.graph = graph;
    }

    public void handleNamespace(String prefix, String name) throws RDFHandlerException {
        NamespaceManager ns = this.graph.getNamespaceManager();
        if (ns != null) {
            ns.add(prefix, name);
        }
    }

    public void handleStatement(Statement statement) throws RDFHandlerException {
        Resource subject = statement.getSubject();
        URI predicate = statement.getPredicate();
        Value object = statement.getObject();
        Resource context = statement.getContext();
        if (context == null) {
            context = this.quadContext;
        }
        this.graph.edge(subject, predicate, object, context);
    }

    public URI getQuadContext() {
        return this.quadContext;
    }

    public void setQuadContext(URI quadContext) {
        this.quadContext = quadContext;
    }
}

