/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import io.konig.core.Context;
import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Term;
import io.konig.core.Vertex;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphWriter {
    private static final Logger logger = LoggerFactory.getLogger(GraphWriter.class);
    Graph graph;
    Context context;
    Context inverse;
    ByteArrayOutputStream out;
    DataOutputStream data;
    short bnodeCount = 1;
    private Map<String, Short> bnodeMap = new HashMap<String, Short>();
    private PromiseInfo promiseInfo;
    private List<PromiseInfo> promiseInfoList = new ArrayList<PromiseInfo>();

    public GraphWriter(Graph graph, Context context) {
        this.graph = graph;
        this.context = context;
        this.inverse = context.inverse();
        this.promiseInfo = new PromiseInfo();
        this.promiseInfoList.add(this.promiseInfo);
    }

    public byte[] write() throws IOException {
        this.out = new ByteArrayOutputStream();
        this.data = new DataOutputStream(this.out);
        this.data.writeShort(1);
        this.writeString(this.context.getContextIRI());
        Collection<Vertex> list = this.graph.vertices();
        for (Vertex v : list) {
            this.writeVertex(v);
        }
        byte[] array = this.out.toByteArray();
        this.deliverPromises(array);
        return array;
    }

    private void deliverPromises(byte[] array) {
        for (PromiseInfo info : this.promiseInfoList) {
            info.deliverPromises(array);
        }
    }

    private void writeVertex(Vertex v) throws IOException {
        Resource id = v.getId();
        Term term = this.inverse.getTerm(id.stringValue());
        Set<Map.Entry<URI, Set<Edge>>> set = v.outEdges();
        if (term != null && set.isEmpty()) {
            return;
        }
        int position = this.out.size();
        this.promiseInfo.putSubject(v.getId().stringValue(), new Integer(position));
        if (id instanceof URI) {
            this.writeIRI((URI)id);
        } else {
            this.writeBNode((BNode)id);
        }
        this.data.writeShort(set.size());
        for (Map.Entry<URI, Set<Edge>> e : set) {
            URI predicate = e.getKey();
            this.writeIRI(predicate);
            Set<Edge> value = e.getValue();
            this.data.writeShort(value.size());
            for (Edge edge : value) {
                logger.debug("WRITE: {} {} {}", new Object[]{id.stringValue(), edge.getPredicate().stringValue(), edge.getObject().stringValue()});
                this.writeObject(edge.getObject());
            }
        }
        Graph namedGraph = v.asNamedGraph();
        if (namedGraph != null) {
            logger.debug("WRITE: GRAPH {}", (Object)id.stringValue());
            PromiseInfo oldInfo = this.promiseInfo;
            this.promiseInfo = new PromiseInfo();
            this.promiseInfoList.add(this.promiseInfo);
            Collection<Vertex> list = namedGraph.vertices();
            short size = (short)list.size();
            this.data.writeByte(11);
            this.data.writeShort(size);
            for (Vertex vertex : list) {
                this.writeVertex(vertex);
            }
            this.promiseInfo = oldInfo;
        }
    }

    private void writeObject(Value object) throws IOException {
        if (object instanceof URI) {
            Term term = this.inverse.getTerm(object.stringValue());
            if (term != null) {
                this.data.writeByte(1);
                this.data.writeShort(term.getIndex());
            } else {
                Integer position = this.promiseInfo.subjectMap.get(object.stringValue());
                this.data.writeByte(5);
                if (position == null) {
                    int mark = this.out.size();
                    this.promiseInfo.addPromise(mark, (Resource)object);
                    this.data.writeInt(0);
                } else {
                    this.data.writeInt(position);
                }
            }
        } else if (object instanceof BNode) {
            BNode bnode = (BNode)object;
            this.writeBNode(bnode);
        } else {
            Literal literal = (Literal)object;
            URI type = literal.getDatatype();
            String language = literal.getLanguage();
            if (type != null) {
                this.writeLiteralIRI(type);
            } else if (language != null) {
                this.data.writeByte(9);
                this.writeString(language);
            } else {
                this.data.writeByte(10);
            }
            this.writeString(literal.stringValue());
        }
    }

    private void writeLiteralIRI(URI id) throws IOException {
        String stringValue = id.stringValue();
        Term term = this.inverse.getTerm(stringValue);
        if (term != null) {
            this.data.writeByte(6);
            this.data.writeShort(term.getIndex());
        } else {
            String namespace = id.getNamespace();
            term = this.inverse.getTerm(namespace);
            if (term != null) {
                this.data.writeByte(7);
                this.data.writeShort(term.getIndex());
                this.writeString(id.getLocalName());
            } else {
                this.data.writeByte(8);
                this.writeString(stringValue);
            }
        }
    }

    private short shortBNode(BNode bnode) {
        Short id = this.bnodeMap.get(bnode.getID());
        if (id == null) {
            this.bnodeCount = (short)(this.bnodeCount + 1);
            id = new Short(this.bnodeCount);
            this.bnodeMap.put(bnode.getID(), id);
        }
        return id;
    }

    private void writeBNode(BNode id) throws IOException {
        this.data.writeByte(4);
        this.data.writeShort(this.shortBNode(id));
    }

    private void writeIRI(URI id) throws IOException {
        String stringValue = id.stringValue();
        Term term = this.inverse.getTerm(stringValue);
        if (term != null) {
            this.data.writeByte(1);
            this.data.writeShort(term.getIndex());
        } else {
            String namespace = id.getNamespace();
            term = this.inverse.getTerm(namespace);
            if (term != null) {
                this.data.writeByte(2);
                this.data.writeShort(term.getIndex());
                this.writeString(id.getLocalName());
            } else {
                this.data.writeByte(3);
                this.writeString(stringValue);
            }
        }
    }

    private void writeString(String value) throws IOException {
        if (value == null) {
            value = "";
        }
        byte[] array = value.getBytes();
        this.data.write(array);
        this.data.writeByte(0);
    }

    static class Promise {
        Resource target;
        int mark;

        public Promise(Resource target, int mark) {
            this.target = target;
            this.mark = mark;
        }
    }

    static class PromiseInfo {
        Map<String, Integer> subjectMap = new HashMap<String, Integer>();
        Map<String, List<Promise>> promiseMap = new HashMap<String, List<Promise>>();

        PromiseInfo() {
        }

        private void putSubject(String resource, Integer index) {
            this.subjectMap.put(resource, index);
        }

        private void addPromise(int mark, Resource target) {
            Promise promise = new Promise(target, mark);
            String key = target.stringValue();
            List<Promise> list = this.promiseMap.get(key);
            if (list == null) {
                list = new ArrayList<Promise>();
                this.promiseMap.put(key, list);
            }
            list.add(promise);
        }

        private void deliverPromises(byte[] array) {
            ByteBuffer buffer = ByteBuffer.wrap(array);
            for (Map.Entry<String, List<Promise>> e : this.promiseMap.entrySet()) {
                String resourceKey = e.getKey();
                Integer position = this.subjectMap.get(resourceKey);
                List<Promise> list = e.getValue();
                for (Promise promise : list) {
                    buffer.position(promise.mark);
                    buffer.putInt(position);
                }
            }
        }
    }
}

