/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import io.konig.core.ContextManager;
import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.io.GraphLoadHandler;
import io.konig.core.io.JsonldParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.openrdf.model.URI;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

public class JsonldLoader {
    private URI quadContext;

    public void load(Reader reader, Graph graph) throws RDFParseException, RDFHandlerException, IOException {
        this.load(reader, graph, null, null);
    }

    public void load(Reader reader, Graph graph, ContextManager contextManager) throws RDFParseException, RDFHandlerException, IOException {
        this.load(reader, graph, contextManager, null);
    }

    public void load(InputStream input, Graph graph, ContextManager contextManager, NamespaceManager nsManager) throws RDFParseException, RDFHandlerException, IOException {
        InputStreamReader reader = new InputStreamReader(input);
        this.load(reader, graph, contextManager, nsManager);
    }

    public void load(InputStream input, Graph graph) throws RDFParseException, RDFHandlerException, IOException {
        this.load(input, graph, null, null);
    }

    public void load(Reader reader, Graph graph, ContextManager contextManager, NamespaceManager nsManager) throws RDFParseException, RDFHandlerException, IOException {
        JsonldParser parser = new JsonldParser(contextManager, nsManager);
        GraphLoadHandler handler = new GraphLoadHandler(graph);
        handler.setQuadContext(this.quadContext);
        parser.setRDFHandler((RDFHandler)handler);
        parser.parse(reader, "");
    }

    public URI getQuadContext() {
        return this.quadContext;
    }

    public void setQuadContext(URI quadContext) {
        this.quadContext = quadContext;
    }
}

