/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.konig.core.Context;
import io.konig.core.ContextManager;
import io.konig.core.KonigValueFactory;
import io.konig.core.ListHandler;
import io.konig.core.NamespaceManager;
import io.konig.core.Term;
import io.konig.core.UidGenerator;
import io.konig.core.io.ContextReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.RDFParserBase;

public class JsonldParser
extends RDFParserBase {
    private ContextReader contextReader;
    private NamespaceManager namespaceManager;

    public JsonldParser(ContextManager contextManager) {
        this(contextManager, new KonigValueFactory());
    }

    public JsonldParser(ContextManager contextManager, NamespaceManager nsManager) {
        this(contextManager, nsManager, new KonigValueFactory());
    }

    public JsonldParser(ContextManager contextManager, NamespaceManager namespaceManager, ValueFactory valueFactory) {
        super(valueFactory);
        this.contextReader = new ContextReader(contextManager);
        this.namespaceManager = namespaceManager;
    }

    public JsonldParser(ContextManager contextManager, ValueFactory valueFactory) {
        this(contextManager, null, valueFactory);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    public void parse(InputStream stream, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.parse(new InputStreamReader(stream), baseURI);
    }

    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(reader);
        if (!(node instanceof ObjectNode)) {
            throw new RDFParseException("Root element is not an object");
        }
        Worker worker = new Worker(baseURI);
        worker.parseObject((ObjectNode)node);
        this.rdfHandler.endRDF();
    }

    private class Worker {
        private String baseURI;
        private Context context;
        private String valueKey = "@value";
        private String idKey = "@id";
        private String typeKey = "@type";
        private String languageKey = "@language";

        public Worker(String baseURI) {
            this.baseURI = baseURI;
        }

        private BNode bnode() {
            return JsonldParser.this.valueFactory.createBNode(UidGenerator.INSTANCE.next());
        }

        private Resource parseObject(ObjectNode object) throws RDFParseException, RDFHandlerException {
            JsonNode idNode;
            Context saveContext = this.context;
            String saveIdKey = this.idKey;
            String saveValueKey = this.valueKey;
            String saveTypeKey = this.typeKey;
            String saveLanguageKey = this.languageKey;
            BNode subject = null;
            JsonNode contextNode = object.get("@context");
            if (contextNode != null) {
                try {
                    this.context = JsonldParser.this.contextReader.parse(object);
                    this.context.compile();
                }
                catch (Throwable oops) {
                    throw new RDFHandlerException(oops);
                }
                this.valueKey = this.context.alias("@value");
                this.idKey = this.context.alias("@id");
                this.typeKey = this.context.alias("@type");
                this.languageKey = this.context.alias("@language");
            }
            if ((idNode = object.get(this.idKey)) == null) {
                subject = this.bnode();
            } else {
                String idValue = idNode.asText();
                if (idValue.startsWith("_:")) {
                    idValue = idValue.substring(2);
                    subject = JsonldParser.this.valueFactory.createBNode(idValue);
                } else {
                    subject = this.iri(idValue);
                }
            }
            Iterator sequence = object.fields();
            while (sequence.hasNext()) {
                Map.Entry e = (Map.Entry)sequence.next();
                String fieldName = (String)e.getKey();
                JsonNode value = (JsonNode)e.getValue();
                if ("@context".equals(fieldName) || "@id".equals(fieldName)) continue;
                if ("@graph".equals(fieldName)) {
                    if (value instanceof ArrayNode) {
                        this.parseGraph((ArrayNode)value);
                        continue;
                    }
                    throw new RDFParseException("@graph must have array value");
                }
                Term term = null;
                URI predicate = null;
                if (this.typeKey.equals(fieldName)) {
                    predicate = RDF.TYPE;
                } else {
                    Term term2 = term = this.context == null ? null : this.context.getTerm(fieldName);
                    if (term != null) {
                        fieldName = term.getExpandedIdValue();
                    } else if (this.context != null) {
                        fieldName = this.context.expandIRI(fieldName);
                    }
                    predicate = JsonldParser.this.valueFactory.createURI(fieldName);
                }
                if (value instanceof ArrayNode) {
                    if (term != null && "@list".equals(term.getContainer())) {
                        this.handleListField((Resource)subject, predicate, term, (ArrayNode)value);
                        continue;
                    }
                    this.handleSetField((Resource)subject, predicate, term, (ArrayNode)value);
                    continue;
                }
                this.handleField((Resource)subject, predicate, value, term);
            }
            this.context = saveContext;
            this.idKey = saveIdKey;
            this.valueKey = saveValueKey;
            this.typeKey = saveTypeKey;
            this.languageKey = saveLanguageKey;
            return subject;
        }

        private void parseGraph(ArrayNode array) throws RDFParseException, RDFHandlerException {
            for (int i = 0; i < array.size(); ++i) {
                JsonNode node = array.get(i);
                if (!(node instanceof ObjectNode)) {
                    throw new RDFParseException("@graph elements must be objects");
                }
                this.parseObject((ObjectNode)node);
            }
        }

        private void handleField(Resource subject, URI predicate, JsonNode value, Term term) throws RDFParseException, RDFHandlerException {
            Value object = this.toValue(subject, predicate, term, value);
            if (object != null) {
                JsonldParser.this.rdfHandler.handleStatement(JsonldParser.this.valueFactory.createStatement(subject, predicate, object));
            }
        }

        private void handleSetField(Resource subject, URI predicate, Term term, ArrayNode array) throws RDFParseException, RDFHandlerException {
            for (int i = 0; i < array.size(); ++i) {
                Value value = this.toValue(subject, predicate, term, array.get(i));
                Statement s = JsonldParser.this.valueFactory.createStatement(subject, predicate, value);
                JsonldParser.this.rdfHandler.handleStatement(s);
            }
        }

        private void handleListField(Resource subject, URI predicate, Term term, ArrayNode array) throws RDFHandlerException, RDFParseException {
            if (JsonldParser.this.rdfHandler instanceof ListHandler) {
                List<Value> valueList = this.toValueList(subject, predicate, term, array);
                ListHandler listHandler = (ListHandler)JsonldParser.this.rdfHandler;
                listHandler.handleList(subject, predicate, valueList);
            } else {
                BNode bnode = JsonldParser.this.valueFactory.createBNode();
                JsonldParser.this.rdfHandler.handleStatement(JsonldParser.this.valueFactory.createStatement(subject, predicate, (Value)bnode));
                for (int i = 0; i < array.size(); ++i) {
                    Value value = this.toValue(subject, predicate, term, array.get(i));
                    Statement st = JsonldParser.this.valueFactory.createStatement((Resource)bnode, RDF.FIRST, value);
                    JsonldParser.this.rdfHandler.handleStatement(st);
                    BNode next = JsonldParser.this.valueFactory.createBNode();
                    JsonldParser.this.rdfHandler.handleStatement(JsonldParser.this.valueFactory.createStatement((Resource)bnode, RDF.REST, (Value)next));
                    bnode = next;
                }
            }
        }

        private List<Value> toValueList(Resource subject, URI predicate, Term term, ArrayNode array) throws RDFParseException, RDFHandlerException {
            ArrayList<Value> list = new ArrayList<Value>();
            for (int i = 0; i < array.size(); ++i) {
                JsonNode node = array.get(i);
                Value value = this.toValue(subject, predicate, term, node);
                list.add(value);
            }
            return list;
        }

        private Value toValue(Resource subject, URI predicate, Term term, JsonNode value) throws RDFParseException, RDFHandlerException {
            Object object = null;
            if (value instanceof ObjectNode) {
                ObjectNode node = (ObjectNode)value;
                JsonNode valueNode = node.get(this.valueKey);
                if (valueNode != null) {
                    String valueString = valueNode.asText();
                    JsonNode typeNode = node.get(this.typeKey);
                    if (typeNode != null) {
                        URI typeIRI = this.iri(typeNode.asText());
                        object = JsonldParser.this.valueFactory.createLiteral(valueString, typeIRI);
                    } else {
                        JsonNode languageNode = node.get(this.languageKey);
                        if (languageNode != null) {
                            String language = languageNode.asText();
                            object = JsonldParser.this.valueFactory.createLiteral(valueString, language);
                        } else {
                            object = JsonldParser.this.valueFactory.createLiteral(valueString);
                        }
                    }
                } else {
                    String language;
                    URI datatype;
                    object = term != null ? ((datatype = term.getExpandedType()) != null ? JsonldParser.this.valueFactory.createLiteral(node.asText(), datatype) : ((language = term.getLanguage()) != null ? JsonldParser.this.valueFactory.createLiteral(node.asText(), language) : this.parseObject((ObjectNode)value))) : this.parseObject((ObjectNode)value);
                }
            } else {
                if (value instanceof ArrayNode) {
                    if ("@list".equals(term.getContainer())) {
                        this.handleListField(subject, predicate, term, (ArrayNode)value);
                    } else {
                        this.handleSetField(subject, predicate, term, (ArrayNode)value);
                    }
                    return null;
                }
                if (value.isValueNode()) {
                    String language;
                    URI datatype;
                    String text = value.asText();
                    object = term != null ? ("@id".equals(term.getType()) ? this.iri(text) : ((datatype = term.getExpandedType()) != null ? JsonldParser.this.valueFactory.createLiteral(text, datatype) : ((language = term.getLanguage()) != null ? JsonldParser.this.valueFactory.createLiteral(text, language) : JsonldParser.this.valueFactory.createLiteral(text)))) : (predicate.equals((Object)RDF.TYPE) ? this.iri(text) : JsonldParser.this.valueFactory.createLiteral(text));
                } else {
                    throw new RDFParseException("Invalid node type");
                }
            }
            return object;
        }

        private URI iri(String idValue) throws RDFParseException {
            if (idValue.startsWith("http://") || idValue.startsWith("https://") || idValue.startsWith("urn:")) {
                return JsonldParser.this.valueFactory.createURI(idValue);
            }
            int colon = idValue.indexOf(58);
            if (colon >= 0) {
                if (this.context == null) {
                    throw new RDFParseException("Cannot expand IRI '" + idValue + "' because context is not defined");
                }
                String prefix = idValue.substring(0, colon);
                Term term = this.context.getTerm(prefix);
                if (term != null) {
                    Namespace ns;
                    String localName = idValue.substring(colon + 1);
                    String namespace = term.getExpandedIdValue();
                    if (JsonldParser.this.namespaceManager != null && (ns = JsonldParser.this.namespaceManager.findByName(namespace)) == null) {
                        JsonldParser.this.namespaceManager.add(prefix, namespace);
                    }
                    return JsonldParser.this.valueFactory.createURI(namespace + localName);
                }
                return JsonldParser.this.valueFactory.createURI(idValue);
            }
            Term term = this.context.getTerm(idValue);
            if (term != null) {
                return term.getExpandedId();
            }
            return JsonldParser.this.valueFactory.createURI(this.baseURI + idValue);
        }
    }
}

