/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import io.konig.core.ListHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class ListRdfHandler
implements RDFHandler {
    private ListHandler listHandler;
    private RDFHandler delegate;
    private Map<String, RdfList> listMap;
    private Map<String, StatementList> objectMap;

    public ListRdfHandler(ListHandler listHandler, RDFHandler delegate) {
        this.listHandler = listHandler;
        this.delegate = delegate;
    }

    public void startRDF() throws RDFHandlerException {
        this.listMap = new HashMap<String, RdfList>();
        this.objectMap = new HashMap<String, StatementList>();
        this.delegate.startRDF();
    }

    public void endRDF() throws RDFHandlerException {
        for (RdfList list : this.listMap.values()) {
            if (list.prev != null) continue;
            List<Value> javaList = list.toJavaList();
            StatementList sequence = this.objectMap.get(list.subject.stringValue());
            while (sequence != null) {
                Statement s = sequence.statement;
                this.listHandler.handleList(s.getSubject(), s.getPredicate(), javaList);
                sequence = sequence.rest;
            }
        }
        this.delegate.endRDF();
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.delegate.handleNamespace(prefix, uri);
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        Resource subject = st.getSubject();
        URI predicate = st.getPredicate();
        Value object = st.getObject();
        if (predicate.equals((Object)RDF.FIRST)) {
            this.list(subject).first = object;
        } else if (predicate.equals((Object)RDF.REST)) {
            if (!object.equals(RDF.NIL)) {
                RdfList target = this.list(subject);
                target.rest = this.list((Resource)object);
                target.rest.prev = target;
            }
        } else {
            if (object instanceof Resource) {
                StatementList slist = this.objectMap.get(object.stringValue());
                if (slist == null) {
                    this.objectMap.put(object.stringValue(), new StatementList(st));
                } else {
                    slist.rest = new StatementList(st);
                }
            }
            this.delegate.handleStatement(st);
        }
    }

    private RdfList list(Resource subject) {
        RdfList list = this.listMap.get(subject.stringValue());
        if (list == null) {
            list = new RdfList(subject);
            this.listMap.put(subject.stringValue(), list);
        }
        return list;
    }

    public void handleComment(String comment) throws RDFHandlerException {
        this.delegate.handleComment(comment);
    }

    private static class RdfList {
        private Resource subject;
        private Value first;
        private RdfList rest;
        private RdfList prev;

        public RdfList(Resource subject) {
            this.subject = subject;
        }

        public List<Value> toJavaList() {
            ArrayList<Value> result = new ArrayList<Value>();
            RdfList current = this;
            while (current != null) {
                result.add(current.first);
                current = current.rest;
            }
            return result;
        }
    }

    private static class StatementList {
        private Statement statement;
        private StatementList rest;

        public StatementList(Statement s) {
            this.statement = s;
        }
    }
}

