/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import io.konig.core.Context;
import io.konig.core.NamespaceManager;
import io.konig.core.io.PrettyPrintable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.util.Literals;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.turtle.TurtleUtil;

public class PrettyPrintWriter
extends PrintWriter {
    private static final int MAX_BUFFER_SIZE = 2014;
    private boolean prettyPrint = true;
    private int indentLevel;
    private String indentText = "   ";
    private boolean escapeSingleQuote;
    private NamespaceManager nsManager;
    private List<AutoMode> autoMode = new ArrayList<AutoMode>();
    private char[] charBuffer = null;
    private Context lastWrittenContext;
    private boolean suppressContext = false;
    private static final Set<Class<?>> WRAPPER_TYPES = PrettyPrintWriter.getWrapperTypes();

    public PrettyPrintWriter(Writer arg0) {
        super(arg0);
        this.autoMode.add(AutoMode.NONE);
    }

    public static PrettyPrintWriter of(Writer out) {
        return out instanceof PrettyPrintWriter ? (PrettyPrintWriter)out : new PrettyPrintWriter(out);
    }

    public PrettyPrintWriter(OutputStream arg0) {
        super(arg0);
    }

    public PrettyPrintWriter(String arg0) throws FileNotFoundException {
        super(arg0);
    }

    public PrettyPrintWriter(File arg0) throws FileNotFoundException {
        super(arg0);
    }

    public PrettyPrintWriter(Writer arg0, boolean arg1) {
        super(arg0, arg1);
    }

    public PrettyPrintWriter(OutputStream arg0, boolean arg1) {
        super(arg0, arg1);
    }

    public PrettyPrintWriter(String arg0, String arg1) throws FileNotFoundException, UnsupportedEncodingException {
        super(arg0, arg1);
    }

    public PrettyPrintWriter(File arg0, String arg1) throws FileNotFoundException, UnsupportedEncodingException {
        super(arg0, arg1);
    }

    public boolean isSuppressContext() {
        return this.suppressContext;
    }

    public void setSuppressContext(boolean suppressContext) {
        this.suppressContext = suppressContext;
    }

    public NamespaceManager getNamespaceManager() {
        return this.nsManager;
    }

    public void setNamespaceManager(NamespaceManager nsManager) {
        this.nsManager = nsManager;
    }

    public void pushIndent() {
        ++this.indentLevel;
    }

    public void popIndent() {
        --this.indentLevel;
    }

    public void indent() {
        if (this.prettyPrint) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.print(this.indentText);
            }
        } else {
            this.print(' ');
        }
    }

    public String getIndentText() {
        return this.indentText;
    }

    public void setIndentText(String indentText) {
        this.indentText = indentText;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public void print(char c) {
        if (this.escapeSingleQuote && c == '\'') {
            super.print('\\');
        }
        super.print(c);
    }

    @Override
    public void print(String text) {
        if (this.escapeSingleQuote) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                this.print(c);
            }
        } else {
            super.print(text);
        }
    }

    @Override
    public void println() {
        if (this.prettyPrint) {
            this.print('\n');
        } else {
            this.print(' ');
        }
    }

    public void print(PrettyPrintable object) {
        if (object == null) {
            this.print("null");
        } else {
            object.print(this);
        }
    }

    @Override
    public void print(Object object) {
        this.autoWhitespace();
        super.print(object);
    }

    public void println(PrettyPrintable object) {
        this.print(object);
        this.println();
    }

    public void fieldName(String name) {
        this.indent();
        this.print(name);
        this.print(' ');
    }

    private AutoMode autoMode() {
        return this.autoMode.get(this.autoMode.size() - 1);
    }

    private void autoWhitespace() {
        switch (this.autoMode()) {
            case INDENT: {
                this.indent();
                break;
            }
            case NEWLINE_INDENT: {
                this.println();
                this.indent();
                break;
            }
        }
    }

    public void beginObject(Object pojo) {
        this.autoWhitespace();
        this.pushMode(AutoMode.NONE);
        this.objectRef(pojo);
        this.pushIndent();
    }

    public void objectRef(Object pojo) {
        if (pojo == null) {
            this.println("null");
            return;
        }
        if (pojo instanceof Value) {
            this.value((Value)pojo);
            this.println();
            return;
        }
        Class<?> type = pojo.getClass();
        this.print(type.getSimpleName());
        this.print(':');
        this.println(pojo.hashCode());
    }

    private void value(Value value) {
        if (value instanceof Literal) {
            this.literal((Literal)value);
        } else if (value instanceof URI) {
            this.uri((URI)value);
        } else if (value instanceof BNode) {
            this.bnode((BNode)value);
        }
    }

    public boolean beginObjectField(String fieldName, Object pojo) {
        this.pushMode(AutoMode.NONE);
        if (pojo != null) {
            this.fieldName(fieldName);
            this.beginObject(pojo);
            return true;
        }
        return false;
    }

    public void endObjectField(Object pojo) {
        this.popMode();
        if (pojo != null) {
            this.endObject();
        }
    }

    public void endObject() {
        this.popIndent();
        this.popMode();
    }

    public void field(String fieldName, Object object) {
        this.indent();
        this.print(fieldName);
        this.print(' ');
        if (object instanceof Value) {
            this.value((Value)object);
            this.println();
        } else if (object != null && PrettyPrintWriter.isPrimitiveOrWrapperType(object.getClass())) {
            this.print(object.toString());
            this.println();
        } else if (object instanceof String) {
            this.literalString((String)object);
            this.println();
        } else if (object != null && object.getClass().isEnum()) {
            Enum enumValue = (Enum)object;
            this.print(enumValue.name());
            this.println();
        } else {
            this.objectRef(object);
        }
    }

    private static boolean isPrimitiveOrWrapperType(Class<?> type) {
        return type.isPrimitive() || PrettyPrintWriter.isWrapperType(type);
    }

    private static boolean isWrapperType(Class<?> clazz) {
        return WRAPPER_TYPES.contains(clazz);
    }

    private static Set<Class<?>> getWrapperTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Short.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        ret.add(Void.class);
        return ret;
    }

    public void field(String fieldName, PrettyPrintable object) {
        if (object != null) {
            this.indent();
            this.print(fieldName);
            this.print(' ');
            this.println(object);
        }
    }

    public void literal(Literal literal) {
        String label = literal.getLabel();
        URI datatype = literal.getDatatype();
        if (XMLSchema.INTEGER.equals((Object)datatype) || XMLSchema.DECIMAL.equals((Object)datatype) || XMLSchema.DOUBLE.equals((Object)datatype) || XMLSchema.BOOLEAN.equals((Object)datatype)) {
            try {
                this.write(XMLDatatypeUtil.normalize((String)label, (URI)datatype));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.literalString(label);
        if (Literals.isLanguageLiteral((Literal)literal)) {
            this.write("@");
            this.write(literal.getLanguage());
        } else if (!XMLSchema.STRING.equals((Object)datatype)) {
            this.write("^^");
            this.uri(datatype);
        }
    }

    public void literalString(String label) {
        if (label.indexOf(10) != -1 || label.indexOf(13) != -1 || label.indexOf(9) != -1) {
            this.write("\"\"\"");
            this.write(TurtleUtil.encodeLongString((String)label));
            this.write("\"\"\"");
        } else {
            this.write("\"");
            this.write(TurtleUtil.encodeString((String)label));
            this.write("\"");
        }
    }

    public void bnode(BNode bnode) {
        this.print("_:");
        this.print(bnode.getID());
    }

    public void resource(Resource resource) {
        if (resource instanceof URI) {
            this.uri((URI)resource);
        } else if (resource instanceof BNode) {
            this.bnode((BNode)resource);
        }
    }

    public void uri(URI uri) {
        Namespace ns;
        if (this.nsManager != null && (ns = this.nsManager.findByName(uri.getNamespace())) != null) {
            this.print(ns.getPrefix());
            this.print(':');
            this.print(uri.getLocalName());
            return;
        }
        this.print('<');
        this.print(uri.stringValue());
        this.print('>');
    }

    public void beginArray(String fieldName) {
        this.fieldName(fieldName);
        this.pushMode(AutoMode.NEWLINE_INDENT);
        this.pushIndent();
    }

    private void pushMode(AutoMode mode) {
        this.autoMode.add(mode);
    }

    public void endArray(String fieldName) {
        this.popIndent();
        this.popMode();
    }

    private void popMode() {
        this.autoMode.remove(this.autoMode.size() - 1);
    }

    public boolean isEscapeSingleQuote() {
        return this.escapeSingleQuote;
    }

    public void setEscapeSingleQuote(boolean escapeSingleQuote) {
        this.escapeSingleQuote = escapeSingleQuote;
    }

    @Override
    public void write(char[] buf, int off, int len) {
        if (this.escapeSingleQuote) {
            int count = 0;
            for (int i = off; i < off + len; ++i) {
                if (buf[i] != '\'') continue;
                ++count;
            }
            if (count > 0) {
                char[] array = null;
                int totalLen = len + count;
                if (totalLen < 2014) {
                    if (this.charBuffer == null) {
                        this.charBuffer = new char[2014];
                        array = this.charBuffer;
                    }
                } else {
                    array = new char[totalLen];
                }
                for (int i = 0; i < len; ++i) {
                    char c = buf[off + i];
                    if (c == '\'') {
                        array[i++] = 92;
                    }
                    array[i] = c;
                }
                buf = array;
                off = 0;
                len = totalLen;
            }
        }
        super.write(buf, off, len);
    }

    public Context getLastWrittenContext() {
        return this.lastWrittenContext;
    }

    public void setLastWrittenContext(Context lastWrittenContext) {
        this.lastWrittenContext = lastWrittenContext;
    }

    private static enum AutoMode {
        NONE,
        INDENT,
        NEWLINE_INDENT;

    }
}

