/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.Vertex;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.impl.RdfUtil;
import io.konig.core.io.Emitter;
import io.konig.core.io.VertexCopier;
import io.konig.core.vocab.VANN;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.SKOS;
import org.openrdf.rio.RDFHandlerException;

public class SkosEmitter
implements Emitter {
    private File outDir;

    public SkosEmitter(File outDir) {
        this.outDir = outDir;
    }

    @Override
    public void emit(Graph graph) throws IOException, KonigException {
        List<Vertex> schemeList;
        Vertex schemeType = graph.getVertex((Resource)SKOS.CONCEPT_SCHEME);
        if (schemeType != null && !(schemeList = schemeType.asTraversal().in(RDF.TYPE).toVertexList()).isEmpty()) {
            if (!this.outDir.exists()) {
                this.outDir.mkdirs();
            }
            for (Vertex scheme : schemeList) {
                this.emit(scheme);
            }
        }
    }

    private void emit(Vertex scheme) throws KonigException {
        Namespace ns;
        String prefix = scheme.stringValue(VANN.preferredNamespacePrefix);
        NamespaceManager nsManager = scheme.getGraph().getNamespaceManager();
        if (prefix == null && nsManager != null && (ns = nsManager.findByName(scheme.getId().stringValue())) != null) {
            prefix = ns.getPrefix();
        }
        if (prefix == null) {
            String msg = MessageFormat.format("vann:preferredNamespacePrefix is not defined for SKOS scheme <{0}>", scheme.getId().stringValue());
            throw new KonigException(msg);
        }
        MemoryGraph target = new MemoryGraph(nsManager);
        VertexCopier copier = new VertexCopier();
        copier.deepCopy(scheme, target);
        List<Vertex> conceptList = scheme.asTraversal().in(SKOS.IN_SCHEME).toVertexList();
        for (Vertex concept : conceptList) {
            copier.deepCopy(concept, target);
        }
        File schemeFile = new File(this.outDir, prefix + ".ttl");
        try {
            RdfUtil.prettyPrintTurtle(nsManager, (Graph)target, schemeFile);
        }
        catch (IOException | RDFHandlerException e) {
            String msg = "Failed to write file: " + schemeFile.getAbsolutePath();
            throw new KonigException(msg);
        }
    }
}

