/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class VertexCopier {
    private List<Resource> excludeClass = new ArrayList<Resource>();
    private List<URI> excludeProperty = new ArrayList<URI>();
    private OwlReasoner reasoner;

    public void deepCopy(Vertex v, Graph g) {
        this.reasoner = new OwlReasoner(v.getGraph());
        HashSet<Resource> memory = new HashSet<Resource>();
        Resource id = v.getId();
        memory.add(id);
        Vertex w = g.vertex(v.getId());
        this.copy(memory, v, w);
    }

    public void excludeProperty(URI ... predicate) {
        for (URI propertyId : predicate) {
            this.excludeProperty.add(propertyId);
        }
    }

    public void excludeClass(Resource ... type) {
        for (Resource owlClass : type) {
            this.excludeClass.add(owlClass);
        }
    }

    private void copy(Set<Resource> memory, Vertex v, Vertex w) {
        if (!this.excluded(v)) {
            for (Map.Entry<URI, Set<Edge>> out : v.outEdges()) {
                URI predicate = out.getKey();
                for (Edge edge : out.getValue()) {
                    Resource objectId;
                    Value object = edge.getObject();
                    w.addProperty(predicate, object);
                    if (!(object instanceof Resource) || memory.contains(objectId = (Resource)object) || !(objectId instanceof BNode) && this.excludeProperty.contains(predicate)) continue;
                    memory.add(objectId);
                    Vertex x = v.getGraph().vertex(objectId);
                    Vertex y = w.getGraph().vertex(objectId);
                    this.copy(memory, x, y);
                }
            }
        }
    }

    private boolean excluded(Vertex v) {
        for (Resource type : this.excludeClass) {
            if (!this.reasoner.isTypeOf(v.getId(), type)) continue;
            return true;
        }
        return false;
    }
}

