/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io.impl;

import io.konig.core.Context;
import io.konig.core.Term;
import io.konig.core.impl.BasicContext;
import java.util.Collection;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;

public class JsonUtil {
    public static Context createContext(Collection<Namespace> set) {
        BasicContext context = new BasicContext(null);
        for (Namespace ns : set) {
            context.add(new Term(ns.getPrefix(), ns.getName(), Term.Kind.NAMESPACE));
        }
        return context;
    }

    public static boolean isInteger(Literal literal) {
        URI datatype = literal.getDatatype();
        return datatype != null && (XMLSchema.INT.equals((Object)datatype) || XMLSchema.BYTE.equals((Object)datatype) || XMLSchema.INTEGER.equals((Object)datatype) || XMLSchema.LONG.equals((Object)datatype));
    }

    public static boolean isRealNumber(Literal literal) {
        URI datatype = literal.getDatatype();
        return datatype != null && (XMLSchema.FLOAT.equals((Object)datatype) || XMLSchema.DOUBLE.equals((Object)datatype) || XMLSchema.DECIMAL.equals((Object)datatype));
    }

    public static boolean isBoolean(Literal literal) {
        URI datatype = literal.getDatatype();
        return datatype != null && XMLSchema.BOOLEAN.equals((Object)datatype);
    }

    public static Object toObject(Literal literal) {
        String value = literal.stringValue();
        if (JsonUtil.isInteger(literal)) {
            return new Long(value);
        }
        if (JsonUtil.isRealNumber(literal)) {
            return new Double(value);
        }
        if (JsonUtil.isBoolean(literal)) {
            return new Boolean("true".equalsIgnoreCase(value));
        }
        return value;
    }
}

