/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.io.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.core.Context;
import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Term;
import io.konig.core.Vertex;
import io.konig.core.io.ContextWriter;
import io.konig.core.io.JsonldGraphWriter;
import io.konig.core.io.KonigWriteException;
import io.konig.core.io.impl.JsonUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;

public class JsonldGraphWriterImpl
implements JsonldGraphWriter {
    @Override
    public void write(Graph graph, Context context, JsonGenerator json) throws KonigWriteException, IOException {
        Worker worker = new Worker(graph, context, json);
        worker.run();
    }

    private static class Worker {
        private Graph graph;
        private Context context;
        private Context inverse;
        private JsonGenerator json;
        private String idKey;
        private String valueKey;
        private String typeKey;
        private String languageKey;

        public Worker(Graph graph, Context context, JsonGenerator json) {
            this.graph = graph;
            this.context = context;
            this.json = json;
            this.inverse = context.inverse();
            this.idKey = context.alias("@id");
            this.valueKey = context.alias("@value");
            this.typeKey = context.alias("@type");
            this.languageKey = context.alias("@language");
        }

        void run() throws IOException {
            List<Term> list;
            this.json.writeStartObject();
            String contextId = this.context.getContextIRI();
            if (contextId == null && (list = this.context.asList()).size() > 0) {
                ContextWriter contextWriter = new ContextWriter();
                this.json.writeFieldName("@context");
                contextWriter.writeContext(this.context, this.json);
            }
            String graphKey = this.context.alias("@graph");
            this.json.writeFieldName(graphKey);
            this.json.writeStartArray();
            for (Vertex vertex : this.graph.vertices()) {
                this.writeVertex(vertex);
            }
            this.json.writeEndArray();
            this.json.writeEndObject();
        }

        private void writeVertex(Vertex vertex) throws IOException {
            Resource subject = vertex.getId();
            String idValue = this.idValue(subject);
            this.json.writeStartObject();
            this.json.writeStringField(this.idKey, idValue);
            Set<Edge> typeSet = vertex.outProperty(RDF.TYPE);
            this.writeType(typeSet);
            Set<Map.Entry<URI, Set<Edge>>> set = vertex.outEdges();
            for (Map.Entry<URI, Set<Edge>> property : set) {
                URI predicate = property.getKey();
                if (predicate.equals((Object)RDF.TYPE)) continue;
                Set<Edge> edgeSet = property.getValue();
                this.writeProperty(predicate, edgeSet);
            }
            this.json.writeEndObject();
        }

        private void writeType(Set<Edge> typeSet) throws IOException {
            if (!typeSet.isEmpty()) {
                boolean isArray;
                this.json.writeFieldName(this.typeKey);
                boolean bl = isArray = typeSet.size() > 1;
                if (isArray) {
                    this.json.writeStartArray();
                }
                for (Edge edge : typeSet) {
                    String typeValue = this.typeValue(edge.getObject());
                    this.json.writeString(typeValue);
                }
                if (isArray) {
                    this.json.writeEndArray();
                }
            }
        }

        private String typeValue(Value object) {
            if (object instanceof URI) {
                return this.typeValue((URI)object);
            }
            if (object instanceof BNode) {
                return "_:" + object.stringValue();
            }
            throw new KonigWriteException("Invalid type: " + object.stringValue());
        }

        private String typeValue(URI uri) {
            Term term = this.inverse.getTerm(uri.stringValue());
            if (term != null) {
                return term.getKey();
            }
            term = this.inverse.getTerm(uri.getNamespace());
            if (term != null) {
                return term.getKey() + ":" + uri.getLocalName();
            }
            return uri.stringValue();
        }

        private String idValue(Resource subject) {
            return subject instanceof URI ? this.compactIRI((URI)subject) : "_:" + subject.stringValue();
        }

        private void writeProperty(URI predicate, Set<Edge> edgeSet) throws IOException {
            boolean isArray;
            if (edgeSet.isEmpty()) {
                return;
            }
            Term term = this.inverse.getTerm(predicate.stringValue());
            String fieldName = this.termName(predicate, term);
            this.json.writeFieldName(fieldName);
            boolean bl = isArray = edgeSet.size() > 1 || term != null && term.getContainer() != null;
            if (isArray) {
                this.json.writeStartArray();
            }
            for (Edge edge : edgeSet) {
                Value object = edge.getObject();
                if (object instanceof Resource) {
                    String idValue = this.idValue((Resource)object);
                    if (term != null && "@id".equals(term.getType())) {
                        this.json.writeString(idValue);
                        continue;
                    }
                    this.json.writeStartObject();
                    this.json.writeStringField(this.idKey, idValue);
                    this.json.writeEndObject();
                    continue;
                }
                Literal literal = (Literal)object;
                URI datatype = literal.getDatatype();
                String language = literal.getLanguage();
                if (datatype != null) {
                    if (term != null && term.getType() != null) {
                        Object value = JsonUtil.toObject(literal);
                        if (value instanceof Long) {
                            this.json.writeNumber(((Long)value).longValue());
                            continue;
                        }
                        if (value instanceof Double) {
                            this.json.writeNumber(((Double)value).doubleValue());
                            continue;
                        }
                        if (value instanceof Boolean) {
                            this.json.writeBoolean(((Boolean)value).booleanValue());
                            continue;
                        }
                        this.json.writeString(literal.stringValue());
                        continue;
                    }
                    this.json.writeStartObject();
                    this.json.writeStringField(this.valueKey, literal.stringValue());
                    if (!XMLSchema.STRING.equals((Object)datatype)) {
                        this.json.writeStringField(this.typeKey, this.compactIRI(datatype));
                    }
                    this.json.writeEndObject();
                    continue;
                }
                if (language != null) {
                    this.json.writeStartObject();
                    this.json.writeStringField(this.valueKey, literal.stringValue());
                    this.json.writeStringField(this.languageKey, language);
                    this.json.writeEndObject();
                    continue;
                }
                if (term == null || term.getType() == null) {
                    this.json.writeStartObject();
                    this.json.writeStringField(this.valueKey, literal.stringValue());
                    this.json.writeEndObject();
                    continue;
                }
                this.json.writeString(literal.stringValue());
            }
            if (isArray) {
                this.json.writeEndArray();
            }
        }

        String compactIRI(URI iri) {
            Term term = this.inverse.getTerm(iri.getNamespace());
            return term == null ? iri.stringValue() : term.getKey() + ":" + iri.getLocalName();
        }

        private String termName(URI predicate, Term term) {
            if (term != null) {
                return term.getKey();
            }
            term = this.inverse.getTerm(predicate.getNamespace());
            if (term != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(term.getKey());
                builder.append(':');
                builder.append(predicate.getLocalName());
                return builder.toString();
            }
            return predicate.stringValue();
        }
    }
}

