/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.konig.core.KonigException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class JsonBuilder {
    private JsonNodeFactory factory;
    private List<JsonNode> stack = new ArrayList<JsonNode>();

    public JsonBuilder() {
        this.factory = JsonNodeFactory.instance;
    }

    public JsonBuilder beginObject() {
        ObjectNode object = this.factory.objectNode();
        JsonNode top = this.top();
        if (top instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)top;
            array.add((JsonNode)object);
        }
        this.stack.add((JsonNode)object);
        return this;
    }

    public JsonBuilder beginObject(String fieldName) {
        ObjectNode subject = (ObjectNode)this.top();
        ObjectNode object = subject.putObject(fieldName);
        this.stack.add((JsonNode)object);
        return this;
    }

    public ObjectNode pop() {
        ObjectNode result = (ObjectNode)this.top();
        this.endObject();
        return result;
    }

    private JsonNode top() {
        return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
    }

    public JsonBuilder endObject() {
        this.stack.remove(this.stack.size() - 1);
        return this;
    }

    public JsonBuilder put(String fieldName, JsonNode value) {
        ObjectNode node = this.peekObject();
        node.set(fieldName, value);
        return this;
    }

    public JsonBuilder put(String fieldName, String value) {
        ObjectNode node = this.peekObject();
        node.set(fieldName, (JsonNode)this.factory.textNode(value));
        return this;
    }

    public JsonBuilder put(String fieldName, int value) {
        this.peekObject().set(fieldName, (JsonNode)this.factory.numberNode(value));
        return this;
    }

    public JsonBuilder put(String fieldName, double value) {
        this.peekObject().set(fieldName, (JsonNode)this.factory.numberNode(value));
        return this;
    }

    public JsonBuilder beginArray(String fieldName) {
        ArrayNode array = this.factory.arrayNode();
        this.peekObject().set(fieldName, (JsonNode)array);
        this.stack.add((JsonNode)array);
        return this;
    }

    public JsonBuilder endArray() {
        return this.endObject();
    }

    private ObjectNode peekObject() {
        return (ObjectNode)this.stack.get(this.stack.size() - 1);
    }

    private JsonNode peekNode() {
        return this.stack.get(this.stack.size() - 1);
    }

    public String toString() {
        JsonNode node = this.peekNode();
        if (node != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
            }
            catch (JsonProcessingException e) {
                throw new KonigException(e);
            }
        }
        return "null";
    }

    public Reader toReader() {
        JsonNode node = this.peekNode();
        String text = node == null ? "" : this.toString();
        return new StringReader(text);
    }
}

