/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.jsonpath;

import io.konig.core.io.BaseParser;
import io.konig.core.jsonpath.JsonPath;
import io.konig.core.jsonpath.JsonPathBracket;
import io.konig.core.jsonpath.JsonPathField;
import io.konig.core.jsonpath.JsonPathIndex;
import io.konig.core.jsonpath.JsonPathKey;
import io.konig.core.jsonpath.JsonPathName;
import io.konig.core.jsonpath.JsonPathOperator;
import io.konig.core.jsonpath.JsonPathParseException;
import io.konig.core.jsonpath.JsonPathRoot;
import io.konig.core.jsonpath.JsonPathWildcard;
import java.io.IOException;
import java.io.Reader;

public class JsonPathParser {
    public JsonPath parse(Reader input) throws JsonPathParseException, IOException {
        Worker worker = new Worker(input);
        return worker.parse();
    }

    private static class Worker
    extends BaseParser {
        protected Worker(Reader reader) {
            super(reader, 8);
        }

        public JsonPath parse() throws IOException, JsonPathParseException {
            JsonPath path = new JsonPath();
            JsonPathOperator jop = this.tryOperator();
            while (jop != null) {
                path.add(jop);
                jop = this.tryOperator();
            }
            return path;
        }

        private JsonPathOperator tryOperator() throws IOException, JsonPathParseException {
            this.skipSpace();
            int c = this.peek();
            switch (c) {
                case 36: {
                    this.read();
                    return new JsonPathRoot();
                }
                case 46: {
                    return this.field();
                }
                case 91: {
                    return this.bracket();
                }
            }
            return null;
        }

        private JsonPathBracket bracket() throws IOException, JsonPathParseException {
            this.read();
            JsonPathKey index = this.key();
            this.skipSpace();
            int c = this.read();
            if (c != 93) {
                throw new JsonPathParseException("Expected ']'");
            }
            return new JsonPathBracket(index);
        }

        private JsonPathOperator field() throws IOException, JsonPathParseException {
            this.read();
            JsonPathKey fieldName = this.key();
            if (fieldName instanceof JsonPathIndex) {
                throw new JsonPathParseException("Expected a name but found an index");
            }
            return new JsonPathField(fieldName);
        }

        private JsonPathKey key() throws IOException, JsonPathParseException {
            String text;
            this.skipSpace();
            StringBuilder buffer = this.buffer();
            int c = this.read();
            while (c > 0) {
                if (!this.isJsonName(c)) {
                    this.unread(c);
                    break;
                }
                buffer.appendCodePoint(c);
                c = this.read();
            }
            if ((text = buffer.toString()).length() == 0) {
                throw new JsonPathParseException("Expected a name or index");
            }
            if ("*".equals(text)) {
                return new JsonPathWildcard();
            }
            if (Character.isDigit(text.charAt(0))) {
                return new JsonPathIndex(Integer.parseInt(text));
            }
            return new JsonPathName(text);
        }

        private boolean isJsonName(int c) {
            return Character.isAlphabetic(c) || Character.isDigit(c) || c == 42;
        }
    }
}

