/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.path;

import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.Path;
import io.konig.core.Vertex;
import io.konig.core.path.OutStep;
import io.konig.core.path.Step;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class DataInjector {
    public void inject(Vertex subject, Path path, Value value) {
        Graph graph = subject.getGraph();
        Resource subjectId = subject.getId();
        List<Step> stepList = path.asList();
        int lastStep = stepList.size() - 1;
        for (int i = 0; i <= lastStep; ++i) {
            Step step = stepList.get(i);
            if (step instanceof OutStep) {
                OutStep outStep = (OutStep)step;
                URI predicate = outStep.getPredicate();
                Value object = subject.getValue(predicate);
                if (i == lastStep) {
                    if (object == null) {
                        graph.edge(subject.getId(), predicate, value);
                        continue;
                    }
                    if (value.equals(object)) continue;
                    StringBuilder message = new StringBuilder();
                    message.append("Cannot inject path value ");
                    message.append(subjectId.stringValue());
                    message.append(path.toString());
                    message.append(' ');
                    message.append(value.toString());
                    message.append(". Conflicting value found: " + object.toString());
                    throw new KonigException(message.toString());
                }
                if (object instanceof Resource) {
                    subject = graph.getVertex((Resource)object);
                    continue;
                }
                Resource id = subject.getId();
                subject = graph.vertex();
                graph.edge(id, predicate, (Value)subject.getId());
                continue;
            }
            throw new KonigException("Unsupported step type: " + step.getClass().getSimpleName());
        }
    }
}

