/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.path;

import io.konig.core.Context;
import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.SPARQLBuilder;
import io.konig.core.TraversalException;
import io.konig.core.Traverser;
import io.konig.core.Vertex;
import io.konig.core.impl.RdfUtil;
import io.konig.core.path.Step;
import io.konig.core.util.TurtleElements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class HasStep
implements Step {
    private List<PredicateValuePair> list = new ArrayList<PredicateValuePair>();

    public HasStep(URI predicate, Value value) {
        this.list.add(new PredicateValuePair(predicate, value));
    }

    public HasStep() {
    }

    public void add(URI predicate, Value value) {
        this.list.add(new PredicateValuePair(predicate, value));
    }

    public List<PredicateValuePair> getPairList() {
        return this.list;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof HasStep) {
            HasStep b = (HasStep)other;
            if (b.list.size() == this.list.size()) {
                if (this.list.size() == 1) {
                    result = this.list.get(0).compareTo(b.list.get(0)) == 0;
                } else {
                    result = true;
                    ArrayList<PredicateValuePair> mine = new ArrayList<PredicateValuePair>(this.list);
                    ArrayList<PredicateValuePair> yours = new ArrayList<PredicateValuePair>(b.list);
                    Collections.sort(mine);
                    Collections.sort(yours);
                    for (int i = 0; i < mine.size(); ++i) {
                        if (((PredicateValuePair)mine.get(i)).compareTo((PredicateValuePair)yours.get(i)) == 0) continue;
                        result = false;
                        break;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void traverse(Traverser traverser) throws TraversalException {
        Graph graph = traverser.getGraph();
        Set<Value> source = traverser.getSource();
        for (Value s : source) {
            if (!(s instanceof Resource)) continue;
            Resource subject = (Resource)s;
            for (PredicateValuePair pair : this.list) {
                if (pair.javaValue != null) {
                    Vertex vertex = graph.getVertex(subject);
                    if (!this.hasValue(vertex, pair)) continue;
                    traverser.addResult(s);
                    continue;
                }
                if (!graph.contains(subject, pair.predicate, pair.value)) continue;
                traverser.addResult(s);
            }
        }
    }

    private boolean hasValue(Vertex vertex, PredicateValuePair pair) {
        Set<Edge> set = vertex.outProperty(pair.predicate);
        for (Edge e : set) {
            Value value = e.getObject();
            if (!(value instanceof Literal)) continue;
            Object object = RdfUtil.javaValue((Literal)value);
            if (!RdfUtil.nearEqual(pair.javaValue, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(SPARQLBuilder builder) {
        String comma = "";
        builder.append('[');
        for (PredicateValuePair pair : this.list) {
            builder.append(comma);
            builder.append(pair.predicate);
            builder.append(' ');
            builder.append(pair.value);
            comma = ",\n";
        }
        builder.append(']');
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String comma = "";
        builder.append('[');
        for (PredicateValuePair pair : this.list) {
            builder.append(comma);
            builder.append(pair.predicate.getLocalName());
            builder.append(' ');
            builder.append(pair.value);
            comma = ",\n";
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public void append(StringBuilder builder, NamespaceManager nsManager) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String toString(Context context) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        URI lastPredicate = null;
        if (this.list.size() == 1) {
            PredicateValuePair pair = this.list.get(0);
            String name = TurtleElements.iri(context, pair.getPredicate());
            String value = TurtleElements.value(context, pair.value);
            builder.append(name);
            builder.append(' ');
            builder.append(value);
        } else {
            for (PredicateValuePair pair : this.list) {
                if (lastPredicate != null) {
                    if (lastPredicate.equals((Object)pair.predicate)) {
                        builder.append(",\n  ");
                    } else {
                        builder.append(";\n  ");
                    }
                } else {
                    builder.append("\n  ");
                }
                String name = TurtleElements.iri(context, pair.predicate);
                builder.append(name);
                builder.append(' ');
                lastPredicate = pair.predicate;
                String value = TurtleElements.value(context, pair.value);
                builder.append(' ');
                builder.append(value);
            }
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public URI getPredicate() {
        return null;
    }

    public static class PredicateValuePair
    implements Comparable<PredicateValuePair> {
        private URI predicate;
        private Value value;
        private Object javaValue;

        public PredicateValuePair(URI predicate, Value object) {
            this.predicate = predicate;
            this.value = object;
            if (this.value instanceof Literal) {
                this.javaValue = RdfUtil.javaValue((Literal)this.value);
            }
        }

        public URI getPredicate() {
            return this.predicate;
        }

        public Value getValue() {
            return this.value;
        }

        @Override
        public int compareTo(PredicateValuePair other) {
            int result = this.predicate.stringValue().compareTo(other.predicate.stringValue());
            if (result == 0) {
                result = this.value.stringValue().compareTo(other.value.stringValue());
            }
            return result;
        }
    }
}

