/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.path;

import io.konig.core.Context;
import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.SPARQLBuilder;
import io.konig.core.TraversalException;
import io.konig.core.Traverser;
import io.konig.core.Vertex;
import io.konig.core.impl.RdfUtil;
import io.konig.core.path.Step;
import io.konig.core.util.TurtleElements;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class OutStep
implements Step {
    URI predicate;

    public OutStep(URI predicate) {
        this.predicate = predicate;
    }

    @Override
    public URI getPredicate() {
        return this.predicate;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof OutStep) {
            OutStep b = (OutStep)other;
            result = this.predicate.equals((Object)b.predicate);
        }
        return result;
    }

    @Override
    public void traverse(Traverser traverser) throws TraversalException {
        Graph graph = traverser.getGraph();
        Set<Value> source = traverser.getSource();
        for (Value s : source) {
            if (!(s instanceof Resource)) continue;
            Vertex subject = graph.vertex((Resource)s);
            Set<Edge> edges = subject.outProperty(this.predicate);
            for (Edge edge : edges) {
                Value object = edge.getObject();
                traverser.addResult(object);
            }
        }
    }

    @Override
    public void visit(SPARQLBuilder builder) {
        builder.append('/');
        builder.append(this.predicate);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public void append(StringBuilder builder, NamespaceManager nsManager) {
        builder.append('/');
        String curie = RdfUtil.optionalCurie(nsManager, this.predicate);
        String value = this.predicate.stringValue();
        if (value.equals(curie)) {
            builder.append('<');
            builder.append(value);
            builder.append('>');
        } else {
            builder.append(curie);
        }
    }

    @Override
    public String toString(Context context) {
        StringBuilder builder = new StringBuilder();
        builder.append('/');
        builder.append(TurtleElements.iri(context, this.predicate));
        return builder.toString();
    }
}

