/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.path;

import io.konig.core.Context;
import io.konig.core.NamespaceManager;
import io.konig.core.Path;
import io.konig.core.Term;
import io.konig.core.impl.BasicContext;
import io.konig.core.path.HasStep;
import io.konig.core.path.InStep;
import io.konig.core.path.OutStep;
import io.konig.core.path.Step;
import io.konig.core.path.VertexStep;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;

public class PathContextBuilder {
    public static Context buildContext(Path path, NamespaceManager nsManager) {
        BasicContext context = new BasicContext(null);
        for (Step step : path.asList()) {
            VertexStep vertex;
            if (step instanceof InStep) {
                InStep inStep = (InStep)step;
                PathContextBuilder.register(nsManager, context, inStep.getPredicate());
                continue;
            }
            if (step instanceof OutStep) {
                OutStep outStep = (OutStep)step;
                PathContextBuilder.register(nsManager, context, outStep.getPredicate());
                continue;
            }
            if (step instanceof HasStep) {
                HasStep hasStep = (HasStep)step;
                for (HasStep.PredicateValuePair pair : hasStep.getPairList()) {
                    PathContextBuilder.register(nsManager, context, pair.getPredicate());
                    if (!(pair.getValue() instanceof URI)) continue;
                    PathContextBuilder.register(nsManager, context, (URI)pair.getValue());
                }
                continue;
            }
            if (!(step instanceof VertexStep) || !((vertex = (VertexStep)step).getResource() instanceof URI)) continue;
            PathContextBuilder.register(nsManager, context, (URI)vertex.getResource());
        }
        path.setContext(context);
        return context;
    }

    private static void register(NamespaceManager nsManager, Context context, URI resource) {
        String localName = resource.getLocalName();
        Term term = context.getTerm(localName);
        if (term == null) {
            String namespace = resource.getNamespace();
            Namespace ns = nsManager.findByName(namespace);
            String prefix = ns == null ? null : ns.getPrefix();
            Term namespaceTerm = null;
            if (prefix != null) {
                namespaceTerm = context.getTerm(prefix);
                if (namespaceTerm == null) {
                    namespaceTerm = context.addTerm(prefix, namespace);
                } else if (!namespaceTerm.getId().equals(namespace)) {
                    namespaceTerm = null;
                }
            }
            if (namespaceTerm == null) {
                context.addTerm(localName, resource.stringValue());
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append(prefix);
                builder.append(':');
                builder.append(localName);
                context.addTerm(localName, builder.toString());
            }
        }
    }
}

