/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.path;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import io.konig.core.Context;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.Path;
import io.konig.core.SPARQLBuilder;
import io.konig.core.Traverser;
import io.konig.core.Vertex;
import io.konig.core.json.KonigJsonPrettyPrinter;
import io.konig.core.path.HasStep;
import io.konig.core.path.InStep;
import io.konig.core.path.OutStep;
import io.konig.core.path.Step;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.XMLSchema;

public class PathImpl
implements Path {
    private List<Step> stepList;
    private Context context;

    public PathImpl() {
        this.stepList = new ArrayList<Step>();
    }

    public PathImpl(List<Step> list) {
        this.stepList = list;
    }

    public void add(Step step) {
        this.stepList.add(step);
    }

    List<Step> getStepList() {
        return this.stepList;
    }

    @Override
    public Path out(URI predicate) {
        this.stepList.add(new OutStep(predicate));
        return this;
    }

    @Override
    public Path in(URI predicate) {
        this.stepList.add(new InStep(predicate));
        return this;
    }

    @Override
    public List<Step> asList() {
        return this.stepList;
    }

    @Override
    public Path copy() {
        return new PathImpl(new ArrayList<Step>(this.stepList));
    }

    @Override
    public Path has(URI predicate, Value value) {
        Step last;
        Step step = last = this.stepList.isEmpty() ? null : this.stepList.get(this.stepList.size() - 1);
        if (last instanceof HasStep) {
            HasStep step2 = (HasStep)last;
            step2.add(predicate, value);
        } else {
            this.stepList.add(new HasStep(predicate, value));
        }
        return this;
    }

    @Override
    public Set<Value> traverse(Vertex source) {
        HashSet<Value> input = new HashSet<Value>();
        input.add((Value)source.getId());
        Graph graph = source.getGraph();
        Traverser traverser = new Traverser(graph, input);
        for (Step step : this.stepList) {
            traverser.visit(step);
        }
        return traverser.getResultSet();
    }

    @Override
    public Set<Value> traverse(Traverser traverser) {
        for (Step step : this.stepList) {
            traverser.visit(step);
        }
        return traverser.getResultSet();
    }

    @Override
    public void visit(SPARQLBuilder builder) {
        for (Step s : this.stepList) {
            s.visit(builder);
        }
    }

    public String toString() {
        try {
            StringWriter buffer = new StringWriter();
            JsonFactory factory = new JsonFactory();
            JsonGenerator json = factory.createGenerator((Writer)buffer);
            json.setPrettyPrinter((PrettyPrinter)KonigJsonPrettyPrinter.INSTANCE);
            if (this.context != null && !this.context.asList().isEmpty()) {
                buffer.append("@context ");
                this.context.toJson(json);
                json.flush();
                buffer.append("\n");
            }
            for (Step step : this.stepList) {
                buffer.append(step.toString(this.context));
            }
            return buffer.toString();
        }
        catch (IOException e) {
            throw new KonigException(e);
        }
    }

    @Override
    public Path subpath(int start, int end) {
        PathImpl result = new PathImpl();
        for (int i = start; i < end; ++i) {
            result.add(this.stepList.get(i));
        }
        return result;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof Path) {
            Path p = (Path)other;
            List<Step> otherList = p.asList();
            boolean bl = result = otherList.size() == this.stepList.size();
            if (result) {
                Step b;
                Step a;
                for (int i = 0; i < this.stepList.size() && (result = (a = this.stepList.get(i)).equals(b = otherList.get(i))); ++i) {
                }
            }
        }
        return result;
    }

    @Override
    public int length() {
        return this.stepList.size();
    }

    @Override
    public Path subpath(int start) {
        return this.subpath(start, this.stepList.size());
    }

    @Override
    public Value toValue() {
        String text = this.toString();
        return new LiteralImpl(text, XMLSchema.STRING);
    }

    @Override
    public Step remove(int index) {
        return this.stepList.remove(index);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public String toSimpleString() {
        StringBuilder buffer = new StringBuilder();
        for (Step step : this.stepList) {
            buffer.append(step.toString(this.context));
        }
        return buffer.toString();
    }
}

