/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.path;

import io.konig.core.Context;
import io.konig.core.NameMap;
import io.konig.core.NamespaceManager;
import io.konig.core.Path;
import io.konig.core.path.HasStep;
import io.konig.core.path.InStep;
import io.konig.core.path.NamespaceMapAdapter;
import io.konig.core.path.OutStep;
import io.konig.core.path.PathContextBuilder;
import io.konig.core.path.PathImpl;
import io.konig.core.path.PathParseException;
import io.konig.core.path.Step;
import io.konig.core.path.VertexStep;
import io.konig.rio.turtle.NamespaceMap;
import io.konig.rio.turtle.SeaTurtleParser;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class PathParser
extends SeaTurtleParser {
    private NamespaceManager nsManager;

    public PathParser(NamespaceManager nsManager) {
        this((NamespaceMap)(nsManager == null ? null : new NamespaceMapAdapter(nsManager)), (PushbackReader)null);
        this.nsManager = nsManager;
    }

    public PathParser(NamespaceMap map, PushbackReader reader) {
        super(map);
        this.setRDFHandler((RDFHandler)new Handler());
        this.reader = reader;
    }

    public PathParser(NameMap nameMap) {
        this.nameMap = nameMap;
    }

    public Path path(Reader input) throws PathParseException {
        super.initParse(input, "");
        return this.path();
    }

    private Path path() throws PathParseException {
        Context context;
        PathImpl path = new PathImpl();
        try {
            int c;
            this.prologue();
            path.setContext(this.getContext());
            while (!this.done(c = this.next())) {
                this.unread(c);
                Step step = null;
                switch (c) {
                    case 46: 
                    case 47: {
                        step = this.out();
                        break;
                    }
                    case 94: {
                        step = this.in();
                        break;
                    }
                    case 91: {
                        step = this.filter();
                        break;
                    }
                    case 63: {
                        step = this.variable();
                        break;
                    }
                    default: {
                        step = this.namedIndividual();
                    }
                }
                path.asList().add(step);
            }
        }
        catch (IOException | RDFHandlerException | RDFParseException e) {
            throw new PathParseException(e);
        }
        if (this.nameMap != null && (context = path.getContext()).asList().isEmpty() && this.nsManager != null) {
            PathContextBuilder.buildContext(path, this.nsManager);
        }
        return path;
    }

    private Step variable() throws RDFParseException, RDFHandlerException, IOException {
        this.read();
        String name = this.pn_local();
        URIImpl predicate = new URIImpl("http://www.konig.io/ns/var/?" + name);
        return new OutStep((URI)predicate);
    }

    protected boolean done(int c) throws IOException {
        return c == -1;
    }

    @Override
    public String pn_local() throws IOException, RDFParseException {
        StringBuilder builder = this.buffer();
        int c = this.read();
        if (!(this.pn_chars_u(c) || c == 58 || this.inRange(c, 48, 57) || this.plx(c))) {
            this.unread(c);
        } else {
            builder.appendCodePoint(c);
            int last = -1;
            while (this.pn_chars(c = this.read()) || c == 58 || this.plx(c)) {
                builder.appendCodePoint(c);
                last = c;
            }
            this.unread(c);
        }
        return builder.toString();
    }

    private Step namedIndividual() throws RDFParseException, IOException, RDFHandlerException {
        URI iri = this.iri();
        return new VertexStep((Resource)iri);
    }

    private Handler handler() {
        return (Handler)this.getRDFHandler();
    }

    private Step filter() throws RDFParseException, RDFHandlerException, IOException {
        BNode bnode = this.blankNodePropertyList();
        if (bnode == null) {
            StringBuilder err = this.err();
            err.append("BNode property list cannot be empty");
            this.fail(err);
        }
        BlankNodeStep top = this.handler().peek();
        return top.step;
    }

    private Step in() throws RDFParseException, IOException, RDFHandlerException {
        this.read('^');
        URI predicate = this.iri();
        return new InStep(predicate);
    }

    private Step out() throws RDFParseException, IOException, RDFHandlerException {
        int delim = this.read();
        if (delim != 47 && delim != 46) {
            throw new RDFParseException("Expected '.' or '/'");
        }
        URI predicate = this.iri();
        return new OutStep(predicate);
    }

    @Override
    protected void pn_prefix(int c) throws IOException, RDFParseException {
        if (this.pn_chars_base(c)) {
            this.buffer.appendCodePoint(c);
            while (this.pn_chars(c = this.read())) {
                this.buffer.appendCodePoint(c);
            }
        }
        this.unread(c);
    }

    private static class BlankNodeStep {
        private BNode bnode;
        private HasStep step;

        public BlankNodeStep(BNode bnode, HasStep step) {
            this.bnode = bnode;
            this.step = step;
        }
    }

    private static class Handler
    extends RDFHandlerBase {
        List<BlankNodeStep> stack = new ArrayList<BlankNodeStep>();

        private Handler() {
        }

        public void handleStatement(Statement st) throws RDFHandlerException {
            BlankNodeStep top = this.peek();
            Resource subject = st.getSubject();
            URI predicate = st.getPredicate();
            Value object = st.getObject();
            if (!(subject instanceof BNode)) {
                throw new RDFHandlerException("Expected subject to be a BNode, but found: " + subject.toString());
            }
            BNode bnode = (BNode)subject;
            if (top == null) {
                top = new BlankNodeStep(bnode, new HasStep());
                this.stack.add(top);
            }
            if (bnode != top.bnode) {
                throw new RDFHandlerException("Nested BNodes not supported yet.");
            }
            top.step.add(predicate, object);
        }

        private BlankNodeStep peek() {
            return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
        }
    }
}

