/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.path;

import io.konig.core.Context;
import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.SPARQLBuilder;
import io.konig.core.TraversalException;
import io.konig.core.Traverser;
import io.konig.core.Vertex;
import io.konig.core.path.Step;
import io.konig.core.util.TurtleElements;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class VertexStep
implements Step {
    Resource resource;

    public VertexStep(Resource object) {
        this.resource = object;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof VertexStep) {
            VertexStep step = (VertexStep)other;
            result = this.resource.equals(step.resource);
        }
        return result;
    }

    @Override
    public void traverse(Traverser traverser) throws TraversalException {
        Graph graph = traverser.getGraph();
        Set<Value> value = traverser.getSource();
        for (Value v : value) {
            traverser.addResult(v);
        }
        Vertex v = graph.vertex(this.resource);
        traverser.addResult((Value)v.getId());
    }

    @Override
    public void visit(SPARQLBuilder builder) {
        builder.append((Value)this.resource);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public void append(StringBuilder builder, NamespaceManager nsManager) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String toString(Context context) {
        return TurtleElements.value(context, (Value)this.resource);
    }

    @Override
    public URI getPredicate() {
        return null;
    }
}

