/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.pojo;

import io.konig.annotation.RdfProperty;
import io.konig.core.Graph;
import io.konig.core.LocalNameService;
import io.konig.core.NamespaceManager;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmitContext {
    private static final URI NULL = new URIImpl("http://www.konig.io/NULL");
    private static final String NAME_NOT_FOUND = "Name not found";
    private static final String AMBIGUOUS_NAME = "The name is ambiguous";
    private static final Logger logger = LoggerFactory.getLogger(EmitContext.class);
    private NamespaceManager nsManager;
    private LocalNameService nameService;
    private Map<Method, URI> methodMap = new HashMap<Method, URI>();
    private Map<Method, String> ignoredMethod = new HashMap<Method, String>();
    private Set<Class<?>> memory = new HashSet();
    private Set<Class<?>> skipClass = new HashSet();
    private Set<URI> iriReference = null;
    private boolean iriReferenceByDefault;
    private Map<Class<?>, Method> listGetterMap;
    private Set<URI> ignoredProperty = null;
    private ValueFactory valueFactory = new ValueFactoryImpl();

    public EmitContext(Graph graph) {
        this(graph.getNamespaceManager(), graph);
    }

    public EmitContext(NamespaceManager nsManager, LocalNameService nameService) {
        this.nsManager = nsManager;
        this.nameService = nameService;
        this.skipClass.add(String.class);
        this.skipClass.add(Integer.TYPE);
        this.skipClass.add(Integer.class);
        this.skipClass.add(Double.TYPE);
        this.skipClass.add(Double.class);
        this.skipClass.add(Long.TYPE);
        this.skipClass.add(Long.class);
    }

    public Method listGetterMethod(Class<?> rdfListProxy) {
        return this.listGetterMap == null ? null : this.listGetterMap.get(rdfListProxy);
    }

    public void putListGetterMethod(Class<?> rdfListProxy, Method getter) {
        if (this.listGetterMap == null) {
            this.listGetterMap = new HashMap();
        }
        this.listGetterMap.put(rdfListProxy, getter);
    }

    public void addIriReference(URI ... predicate) {
        if (this.iriReference == null) {
            this.iriReference = new HashSet<URI>();
        }
        for (URI id : predicate) {
            this.iriReference.add(id);
        }
    }

    public void addIgnoredProperty(URI ... predicate) {
        if (this.ignoredProperty == null) {
            this.ignoredProperty = new HashSet<URI>();
        }
        for (URI id : predicate) {
            this.ignoredProperty.add(id);
        }
    }

    public boolean isIriReferenceByDefault() {
        return this.iriReferenceByDefault;
    }

    public void setIriReferenceByDefault(boolean iriReferenceByDefault) {
        this.iriReferenceByDefault = iriReferenceByDefault;
    }

    public boolean isIgnoredProperty(URI predicate) {
        return this.ignoredProperty != null && this.ignoredProperty.contains(predicate);
    }

    public boolean isIriReference(URI predicate) {
        return this.iriReferenceByDefault || this.iriReference != null && this.iriReference.contains(predicate);
    }

    public void setLocalNameService(LocalNameService nameService) {
        this.nameService = nameService;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void put(Method method, URI predicate) {
        this.methodMap.put(method, predicate);
    }

    public void register(Class<?> javaClass) {
        if (!this.memory.contains(javaClass) && !this.skipClass.contains(javaClass)) {
            Method[] methodList;
            this.memory.add(javaClass);
            for (Method m : methodList = javaClass.getMethods()) {
                this.getterPredicate(m);
            }
        }
    }

    public NamespaceManager getNamespaceManager() {
        return this.nsManager;
    }

    public void setNamespaceManager(NamespaceManager nsManager) {
        this.nsManager = nsManager;
    }

    public LocalNameService getNameService() {
        return this.nameService;
    }

    public void setNameService(LocalNameService nameService) {
        this.nameService = nameService;
    }

    public URI getterPredicate(Method m) {
        if (m.getDeclaringClass() == Object.class) {
            return null;
        }
        String name = m.getName();
        if ("getId".equals(name)) {
            return null;
        }
        URI result = this.methodMap.get(m);
        if (result == NULL) {
            return null;
        }
        if (result == null) {
            Class<?>[] paramList;
            if (name.startsWith("get") && (paramList = m.getParameterTypes()).length == 0) {
                String resourceName = this.getterResourceName(name);
                Set<URI> nameList = this.nameService == null ? Collections.emptySet() : this.nameService.lookupLocalName(resourceName);
                RdfProperty annotation = this.rdfPropertyAnnotation(m);
                if (annotation != null) {
                    String value = annotation.value();
                    for (URI uri : nameList) {
                        if (!uri.stringValue().equals(value)) continue;
                        if (this.isIgnoredProperty(uri)) {
                            this.methodMap.put(m, NULL);
                            return null;
                        }
                        this.methodMap.put(m, uri);
                        return uri;
                    }
                    result = new URIImpl(value);
                    if (this.isIgnoredProperty(result)) {
                        this.methodMap.put(m, NULL);
                        return null;
                    }
                    this.methodMap.put(m, result);
                    return result;
                }
                if (nameList.size() == 1) {
                    URI resourceId = nameList.iterator().next();
                    this.methodMap.put(m, resourceId);
                    return resourceId;
                }
                if (nameList.isEmpty()) {
                    this.ignoredMethod.put(m, NAME_NOT_FOUND);
                }
                if (!this.ignoredMethod.containsKey(m)) {
                    this.ignoredMethod.put(m, AMBIGUOUS_NAME);
                    if (logger.isWarnEnabled()) {
                        logger.warn("Ambiguous predicate: {}", (Object)nameList.toString());
                    }
                }
            }
            this.methodMap.put(m, NULL);
        }
        return result;
    }

    private RdfProperty rdfPropertyAnnotation(Method m) {
        String methodName = m.getName();
        block2: while (m != null) {
            RdfProperty a = m.getAnnotation(RdfProperty.class);
            if (a != null) {
                return a;
            }
            Class<?> type = m.getDeclaringClass();
            while (type != null) {
                if ((type = type.getSuperclass()) == Object.class) {
                    return null;
                }
                try {
                    m = type.getDeclaredMethod(methodName, new Class[0]);
                    continue block2;
                }
                catch (NoSuchMethodException | SecurityException exception) {
                }
            }
        }
        return null;
    }

    private String getterResourceName(String name) {
        StringBuilder builder = new StringBuilder();
        for (int i = 3; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 3) {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

