/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.pojo;

import io.konig.core.pojo.PojoListener;
import io.konig.core.pojo.impl.MasterPojoHandler;
import io.konig.core.pojo.impl.PojoHandler;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.Resource;

public class PojoContext {
    private Map<Resource, Class<?>> classMap;
    private Map<Class<?>, PojoHandler> pojoHandlerMap = new HashMap();
    private Map<Resource, Object> individualMap = new HashMap<Resource, Object>();
    private PojoHandler pojoHandler;
    private PojoListener pojoListener;

    public PojoContext() {
        this.classMap = new HashMap();
        this.pojoHandler = new MasterPojoHandler();
    }

    public PojoContext(PojoContext source) {
        this.classMap = source.classMap;
        this.pojoHandlerMap = source.pojoHandlerMap;
        this.pojoHandler = source.pojoHandler;
    }

    public void mapClass(Resource owlClass, Class<?> javaClass) {
        this.classMap.put(owlClass, javaClass);
    }

    public Map<Resource, Class<?>> getClassMap() {
        return this.classMap;
    }

    public Class<?> getJavaClass(Resource resource) {
        return this.classMap.get(resource);
    }

    public PojoHandler getPojoHandler(Class<?> javaClass) {
        PojoHandler handler = null;
        while (javaClass != null && handler == null && ((handler = this.pojoHandlerMap.get(javaClass)) != null || (javaClass = javaClass.getSuperclass()) != Object.class)) {
        }
        return handler;
    }

    public PojoHandler putPojoHandler(Class<?> javaClass, PojoHandler pojoHandler) {
        return this.pojoHandlerMap.put(javaClass, pojoHandler);
    }

    public PojoHandler getPojoHandler() {
        return this.pojoHandler;
    }

    public void setPojoHandler(PojoHandler pojoHandler) {
        this.pojoHandler = pojoHandler;
    }

    public <T> T getIndividual(Resource resource, Class<T> javaClass) {
        return (T)this.getIndividual(resource);
    }

    public Object getIndividual(Resource resource) {
        return this.individualMap.get(resource);
    }

    public Map<Resource, Object> getIndividualMap() {
        return this.individualMap;
    }

    public void mapObject(Resource resource, Object pojo) {
        this.individualMap.put(resource, pojo);
    }

    public PojoListener getListener() {
        return this.pojoListener;
    }

    public void setListener(PojoListener pojoListener) {
        this.pojoListener = pojoListener;
    }

    public void notify(Resource resource, Object pojo) {
        if (this.pojoListener != null) {
            this.pojoListener.map(resource, pojo);
        }
    }
}

