/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.pojo;

import io.konig.annotation.RdfList;
import io.konig.annotation.RdfProperty;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.Vertex;
import io.konig.core.pojo.BeanUtil;
import io.konig.core.pojo.ConditionalEmbeddable;
import io.konig.core.pojo.EmitContext;
import io.konig.core.pojo.PojoEmitter;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;

public class SimplePojoEmitter
implements PojoEmitter {
    private static SimplePojoEmitter INSTANCE = new SimplePojoEmitter();
    private ValueFactory valueFactory = ValueFactoryImpl.getInstance();

    public static SimplePojoEmitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void emit(EmitContext context, Object pojo, Graph sink) {
        Worker worker = new Worker(context, sink);
        worker.emit(pojo);
    }

    public void emit(Object pojo, Graph sink) {
        this.emit(new EmitContext(sink), pojo, sink);
    }

    @Override
    public void emit(NamespaceManager nsManager, Shape shape, Object pojo, Graph sink) {
        Worker worker = new Worker(nsManager, sink);
        worker.emit(shape, pojo);
    }

    private class Worker {
        private EmitContext context;
        private Map<Object, Resource> pojoIdMap = new HashMap<Object, Resource>();
        private Set<Object> memory = new HashSet<Object>();
        private Graph sink;
        private NamespaceManager sinkNamespaces;
        private NamespaceManager sourceNamespaces;

        public Worker(EmitContext context, Graph sink) {
            this.context = context;
            this.sink = sink;
            this.sinkNamespaces = sink.getNamespaceManager();
            this.sourceNamespaces = context.getNamespaceManager();
        }

        public Worker(NamespaceManager sourceNamespaces, Graph sink) {
            this.sink = sink;
            this.sourceNamespaces = sourceNamespaces;
            this.sinkNamespaces = sink.getNamespaceManager();
        }

        public void emit(Shape shape, Object pojo) {
            if (!this.memory.contains(pojo)) {
                this.memory.add(pojo);
                Resource subject = this.getId(pojo);
                this.emitProperties(subject, shape, pojo);
            }
        }

        private void emitProperties(Resource subject, Shape shape, Object pojo) {
            List<PropertyConstraint> propertyList = shape.getProperty();
            for (PropertyConstraint p : propertyList) {
                URI predicate = p.getPredicate();
                if (predicate == null) continue;
                Method getter = this.getter(p, pojo);
                if (getter != null) {
                    try {
                        Object value = getter.invoke(pojo, new Object[0]);
                        if (value instanceof Collection) {
                            this.emitCollection(p, subject, predicate, (Collection)value);
                            continue;
                        }
                        if (value == null) continue;
                        Value object = this.toValue(value);
                        this.sink.edge(subject, predicate, object);
                        Shape valueShape = p.getShape();
                        if (valueShape == null) continue;
                        this.emit(valueShape, value);
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new KonigException(e);
                    }
                }
                String predicateName = predicate.getLocalName();
                String message = "On class" + pojo.getClass().getSimpleName() + ", getter not found for predicate: " + predicateName;
                throw new KonigException(message);
            }
        }

        private void emitCollection(PropertyConstraint p, Resource subject, URI predicate, Collection<?> collection) {
            for (Object value : collection) {
                Value object = this.toValue(value);
                this.sink.edge(subject, predicate, object);
                Shape valueShape = p.getShape();
                if (valueShape == null) continue;
                this.emit(valueShape, value);
            }
        }

        private Method getter(PropertyConstraint p, Object pojo) {
            URI predicate = p.getPredicate();
            if (predicate != null) {
                Method[] methodList;
                Class<?> javaClass = pojo.getClass();
                String getterName = BeanUtil.getterName(predicate);
                for (Method m : methodList = javaClass.getMethods()) {
                    String rdfProperty;
                    RdfProperty annotation = m.getAnnotation(RdfProperty.class);
                    if (annotation != null && (rdfProperty = annotation.value()).equals(predicate.stringValue())) {
                        return m;
                    }
                    String methodName = m.getName();
                    if (!methodName.equals(getterName)) continue;
                    return m;
                }
            }
            return null;
        }

        void emit(Object pojo) {
            this.doEmit(null, pojo);
        }

        void doEmit(Resource id, Object pojo) {
            if (!this.memory.contains(pojo)) {
                this.context.register(pojo.getClass());
                if (id == null) {
                    id = this.getId(pojo);
                }
                if (id != null) {
                    this.memory.add(pojo);
                    this.emitProperties(id, pojo);
                }
            }
        }

        private void emitProperties(Resource subject, Object pojo) {
            Method[] methodList;
            Class<?> javaClass = pojo.getClass();
            for (Method m : methodList = javaClass.getMethods()) {
                Object javaObject;
                URI predicate = this.context.getterPredicate(m);
                if (predicate == null) continue;
                try {
                    javaObject = m.invoke(pojo, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new KonigException(e);
                }
                if (javaObject == null) continue;
                if (javaObject.getClass().getAnnotation(RdfList.class) != null) {
                    this.emitRdfListProxy(subject, predicate, javaObject);
                    continue;
                }
                if (javaObject instanceof Collection) {
                    this.emitCollection(subject, predicate, (Collection)javaObject);
                    continue;
                }
                Value object = this.toValue(javaObject);
                if (object != null) {
                    this.registerNamespace(predicate);
                    this.sink.edge(subject, predicate, object);
                }
                if (!this.canEmbed(object, predicate, javaObject)) continue;
                this.doEmit((Resource)object, javaObject);
            }
        }

        private void emitRdfListProxy(Resource subject, URI predicate, Object javaObject) {
            Collection collection = null;
            if (javaObject instanceof Collection) {
                collection = (Collection)javaObject;
            } else {
                Class<?> type = javaObject.getClass();
                Method m = this.context.listGetterMethod(type);
                if (m == null) {
                    for (Method method : type.getMethods()) {
                        if (method.getParameterCount() != 0 || !method.getName().startsWith("get") || !Collection.class.isAssignableFrom(method.getReturnType())) continue;
                        this.context.putListGetterMethod(type, method);
                        try {
                            collection = (Collection)method.invoke(javaObject, new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            throw new KonigException("Failed to invoke getter for @RdfList class: " + type.getName());
                        }
                    }
                }
                if (collection == null) {
                    throw new KonigException("Getter not found for @RdfList class: " + type.getName());
                }
            }
            this.emitRdfList(subject, predicate, collection);
        }

        private void emitCollection(Resource subject, URI predicate, Collection<?> javaObject) {
            boolean registered = false;
            for (Object value : javaObject) {
                Value object = this.toValue(value);
                if (object == null) continue;
                if (!registered) {
                    this.registerNamespace(predicate);
                    registered = true;
                }
                this.sink.edge(subject, predicate, object);
                if (!this.canEmbed(object, predicate, value)) continue;
                this.doEmit((Resource)object, value);
            }
        }

        private boolean canEmbed(Value object, URI predicate, Object javaObject) {
            boolean ok;
            boolean bl = ok = object instanceof Resource && !this.context.isIriReference(predicate);
            if (ok && javaObject instanceof ConditionalEmbeddable) {
                ConditionalEmbeddable e = (ConditionalEmbeddable)javaObject;
                ok = e.isEmbeddabled();
            }
            return ok;
        }

        private void emitRdfList(Resource subject, URI predicate, Collection<?> javaCollection) {
            if (!javaCollection.isEmpty()) {
                Vertex priorList = null;
                for (Object value : javaCollection) {
                    Vertex list = this.sink.vertex();
                    Value object = this.toValue(value);
                    this.sink.edge(list.getId(), RDF.FIRST, object);
                    if (priorList == null) {
                        this.registerNamespace(predicate);
                        this.sink.edge(subject, predicate, (Value)list.getId());
                    } else {
                        this.sink.edge(priorList.getId(), RDF.REST, (Value)list.getId());
                    }
                    priorList = list;
                }
                this.sink.edge(priorList.getId(), RDF.REST, (Value)RDF.NIL);
            }
        }

        private Value toValue(Object object) {
            Value value = BeanUtil.toValue(object);
            if (value != null) {
                if (value instanceof URI) {
                    this.registerNamespace((URI)value);
                }
                return value;
            }
            return this.getId(object);
        }

        private Resource getId(Object pojo) {
            if (pojo == null) {
                return null;
            }
            Resource result = this.pojoIdMap.get(pojo);
            if (result == null) {
                Class<?> javaClass = pojo.getClass();
                try {
                    Method idMethod = javaClass.getMethod("getId", new Class[0]);
                    Class<?> returnType = idMethod.getReturnType();
                    if (Resource.class.isAssignableFrom(returnType) && (result = (Resource)idMethod.invoke(pojo, new Object[0])) != null && result instanceof URI) {
                        URI uri = (URI)result;
                        this.registerNamespace(uri);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                    throw new KonigException(e);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (result == null) {
                result = SimplePojoEmitter.this.valueFactory.createBNode();
            }
            this.pojoIdMap.put(pojo, result);
            return result;
        }

        private void registerNamespace(URI uri) {
            String namespace;
            Namespace ns;
            if (this.sinkNamespaces != null && this.sourceNamespaces != null && (ns = this.sourceNamespaces.findByName(namespace = uri.getNamespace())) != null) {
                this.sinkNamespaces.add(ns);
            }
        }
    }
}

