/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.pojo;

import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.Vertex;
import io.konig.core.pojo.PojoContext;
import io.konig.core.pojo.PojoFactory;
import io.konig.core.pojo.impl.PojoHandler;
import io.konig.core.pojo.impl.PojoInfo;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class SimplePojoFactory
implements PojoFactory {
    private PojoContext context;

    public SimplePojoFactory() {
        this.context = new PojoContext();
    }

    public SimplePojoFactory(PojoContext context) {
        this.context = context;
    }

    public PojoContext getContext() {
        return this.context;
    }

    @Override
    public <T> T create(Vertex v, Class<T> type) throws KonigException {
        Object result = this.context.getIndividual(v.getId());
        if (result == null) {
            PojoHandler pojoHandler = this.context.getPojoHandler();
            PojoInfo info = new PojoInfo();
            info.setContext(this.context);
            info.setVertex(v);
            info.setExpectedJavaClass(type);
            pojoHandler.buildPojo(info);
            result = info.getJavaObject();
        }
        return (T)result;
    }

    @Override
    public void createAll(Graph graph) throws KonigException {
        for (Vertex v : graph.vertices()) {
            Resource id = v.getId();
            if (!(id instanceof URI)) continue;
            this.create(v, null);
        }
    }
}

