/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.pojo.impl;

import io.konig.annotation.RdfList;
import io.konig.annotation.RdfProperty;
import io.konig.core.Edge;
import io.konig.core.KonigException;
import io.konig.core.Vertex;
import io.konig.core.pojo.BeanUtil;
import io.konig.core.pojo.impl.AppendToListHandler;
import io.konig.core.pojo.impl.CollectionValueHandler;
import io.konig.core.pojo.impl.EnumValueHandler;
import io.konig.core.pojo.impl.FloatValueHandler;
import io.konig.core.pojo.impl.MultiValueHandler;
import io.konig.core.pojo.impl.NumberValueHandler;
import io.konig.core.pojo.impl.PojoHandler;
import io.konig.core.pojo.impl.PojoInfo;
import io.konig.core.pojo.impl.PropertyInfo;
import io.konig.core.pojo.impl.RdfListValueHandler;
import io.konig.core.pojo.impl.RdfValueHandler;
import io.konig.core.pojo.impl.ResourceHandler;
import io.konig.core.pojo.impl.StringValueHandler;
import io.konig.core.pojo.impl.ThreePhaseValueHandler;
import io.konig.core.pojo.impl.UriValueHandler;
import io.konig.core.pojo.impl.ValueHandler;
import io.konig.core.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class BasicPojoHandler
implements PojoHandler {
    private Class<?> javaClass;
    private Map<String, ValueHandler> propertyHandlerMap = new HashMap<String, ValueHandler>();
    private Method idMethod;

    public BasicPojoHandler(Class<?> javaClass) {
        this.javaClass = javaClass;
        this.buildPropertyHandlers();
    }

    private void buildPropertyHandlers() {
        Method[] methodList;
        for (Method m : methodList = this.javaClass.getMethods()) {
            if (m.getParameterTypes().length != 1) continue;
            String key = null;
            RdfProperty note = m.getAnnotation(RdfProperty.class);
            if (note != null) {
                key = StringUtil.rdfLocalName(note.value());
                if (key == null) {
                    String methodName = m.getName();
                    throw new KonigException("Invalid URI for RdfProperty of " + methodName);
                }
            } else {
                key = BeanUtil.setterKey(m);
            }
            if (key == null) continue;
            if ("id".equals(key) && m.getParameterTypes()[0].isAssignableFrom(URI.class)) {
                this.idMethod = m;
                continue;
            }
            this.putMethod(key, m);
        }
    }

    private void putMethod(String key, Method m) {
        ValueHandler prior;
        Class<?> type = m.getParameterTypes()[0];
        ValueHandler handler = this.valueHandler(type, m);
        if (m.getName().startsWith("appendTo")) {
            handler = new AppendToListHandler(handler);
        }
        if ((prior = this.propertyHandlerMap.get(key)) != null) {
            handler = this.chooseBestHandler(prior, handler);
        }
        this.propertyHandlerMap.put(key, handler);
    }

    private ValueHandler chooseBestHandler(ValueHandler prior, ValueHandler handler) {
        if (prior instanceof MultiValueHandler) {
            return prior;
        }
        if (handler instanceof MultiValueHandler) {
            return handler;
        }
        if (prior instanceof ResourceHandler) {
            return prior;
        }
        if (handler instanceof ResourceHandler) {
            return handler;
        }
        return prior;
    }

    protected ValueHandler valueHandler(Class<?> type, Method m) {
        ValueHandler result = null;
        result = type == String.class ? new StringValueHandler(m) : (this.isCollectionType(type) ? this.collectionHandler(m) : (type == Number.class ? new NumberValueHandler(m) : (type == Float.TYPE || type == Float.class ? new FloatValueHandler(m) : (type == URI.class ? new UriValueHandler(m) : (type.isEnum() ? this.enumValueHandler(type, m) : (type == Value.class ? new RdfValueHandler(m) : this.resourceHandler(type, m)))))));
        return result;
    }

    private ValueHandler resourceHandler(Class<?> type, Method m) {
        return new ResourceHandler(type, m);
    }

    private ValueHandler enumValueHandler(Class<?> type, Method m) {
        try {
            Method valueToEnum = type.getMethod("fromURI", URI.class);
            return new EnumValueHandler(m, valueToEnum);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new KonigException(e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ValueHandler collectionHandler(Method collectionSetter) throws KonigException {
        void var2_5;
        Class<?> clazz = collectionSetter.getParameterTypes()[0];
        if (clazz.isInterface()) {
            if (List.class.isAssignableFrom(clazz)) {
                Class<ArrayList> clazz2 = ArrayList.class;
            } else {
                if (!Set.class.isAssignableFrom(clazz)) throw new KonigException("Unspported Collection argument for method: " + collectionSetter);
                Class<HashSet> clazz3 = HashSet.class;
            }
        } else if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new KonigException("Abstract collection type not supported on method: " + collectionSetter);
        }
        ValueHandler elementHandler = this.elementHandler((Class<?>)var2_5, collectionSetter);
        RdfListValueHandler rdfListHandler = new RdfListValueHandler((Class<?>)var2_5, collectionSetter, null, elementHandler);
        if (var2_5.getAnnotation(RdfList.class) != null) {
            return rdfListHandler;
        }
        CollectionValueHandler collectionHandler = new CollectionValueHandler((Class<?>)var2_5, collectionSetter, null, elementHandler);
        return new MultiValueHandler(collectionHandler, rdfListHandler);
    }

    private ValueHandler elementHandler(Class<?> collectionType, Method collectionSetter) {
        ValueHandler valueHandler;
        Method adderMethod = this.adderMethod(collectionType);
        if (adderMethod == null) {
            throw new KonigException("adder not found for collection set via " + collectionSetter);
        }
        Class<?> argType = null;
        Type genericParamType = collectionSetter.getGenericParameterTypes()[0];
        if (genericParamType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)genericParamType;
            Type[] argTypes = pType.getActualTypeArguments();
            if (argTypes.length == 1) {
                argType = (Class<?>)argTypes[0];
            }
        } else {
            RdfList rdfList;
            ParameterizedType type;
            Type superClass = collectionType.getGenericSuperclass();
            if (superClass instanceof ParameterizedType && (type = (ParameterizedType)superClass).getActualTypeArguments().length == 1) {
                argType = (Class)type.getActualTypeArguments()[0];
            }
            if (argType == null && (rdfList = collectionType.getAnnotation(RdfList.class)) != null) {
                argType = adderMethod.getParameterTypes()[0];
            }
        }
        if (argType != null && (valueHandler = this.valueHandler(argType, adderMethod)) != null) {
            return valueHandler;
        }
        throw new KonigException("Adder argument not found for collection set via " + collectionSetter);
    }

    private Method adderMethod(Class<?> collectionType) {
        Method[] methodList;
        for (Method m : methodList = collectionType.getMethods()) {
            if (!m.getName().equals("add") || m.getParameterTypes().length != 1) continue;
            return m;
        }
        throw new KonigException("'add' method not found on collection type: " + collectionType);
    }

    private boolean isCollectionType(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || type.getAnnotation(RdfList.class) != null;
    }

    @Override
    public void buildPojo(PojoInfo pojoInfo) throws KonigException {
        Object pojo = this.newInstance(pojoInfo);
        pojoInfo.getContext().mapObject(pojoInfo.getVertex().getId(), pojo);
        pojoInfo.setJavaObject(pojo);
        this.setProperties(pojoInfo);
    }

    protected Object newInstance(PojoInfo pojoInfo) throws KonigException {
        try {
            return this.javaClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new KonigException(e);
        }
    }

    private void setProperties(PojoInfo pojoInfo) throws KonigException {
        Vertex v = pojoInfo.getVertex();
        Set<Map.Entry<URI, Set<Edge>>> outEdges = v.outEdges();
        this.setId(pojoInfo);
        if (!outEdges.isEmpty()) {
            PropertyInfo propertyInfo = new PropertyInfo();
            propertyInfo.setSubject(pojoInfo);
            for (Map.Entry<URI, Set<Edge>> entry : v.outEdges()) {
                ThreePhaseValueHandler phaseHandler;
                ValueHandler edgeHandler;
                URI predicate = entry.getKey();
                propertyInfo.setPredicate(predicate);
                propertyInfo.setObject(null);
                Set<Edge> edgeSet = entry.getValue();
                if (edgeSet.isEmpty() || (edgeHandler = this.propertyHandler(propertyInfo)) == null) continue;
                ThreePhaseValueHandler threePhaseValueHandler = phaseHandler = edgeHandler instanceof ThreePhaseValueHandler ? (ThreePhaseValueHandler)edgeHandler : null;
                if (phaseHandler != null) {
                    phaseHandler.setUp(propertyInfo);
                }
                for (Edge edge : edgeSet) {
                    if (this.handleList(edgeHandler, propertyInfo, edge)) continue;
                    Value object = edge.getObject();
                    propertyInfo.setObject(object);
                    edgeHandler.handleValue(propertyInfo);
                }
                if (phaseHandler == null) continue;
                phaseHandler.tearDown(propertyInfo);
            }
        }
    }

    private boolean handleList(ValueHandler edgeHandler, PropertyInfo propertyInfo, Edge edge) {
        return false;
    }

    private void setId(PojoInfo pojoInfo) throws KonigException {
        Vertex v = pojoInfo.getVertex();
        Resource id = v.getId();
        if (id instanceof URI && this.idMethod != null) {
            URI uri = (URI)id;
            Object javaObject = pojoInfo.getJavaObject();
            try {
                this.idMethod.invoke(javaObject, uri);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                String msg = MessageFormat.format("Failed to invoke {0}.{1} for {2}", javaObject.getClass().getSimpleName(), this.idMethod.getName(), id.stringValue());
                throw new KonigException(msg, e);
            }
        }
    }

    private ValueHandler propertyHandler(PropertyInfo propertyInfo) {
        URI predicate = propertyInfo.getPredicate();
        String localName = predicate.getLocalName();
        return this.propertyHandlerMap.get(localName.toLowerCase());
    }
}

