/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.pojo.impl;

import io.konig.core.KonigException;
import io.konig.core.pojo.impl.ElementInfo;
import io.konig.core.pojo.impl.PojoInfo;
import io.konig.core.pojo.impl.PropertyInfo;
import io.konig.core.pojo.impl.ThreePhaseValueHandler;
import io.konig.core.pojo.impl.ValueHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CollectionValueHandler
implements ThreePhaseValueHandler {
    private Class<?> collectionType;
    private Method collectionSetter;
    private Method collectionGetter;
    private ValueHandler elementHandler;

    public CollectionValueHandler(Class<?> collectionType, Method collectionSetter, Method collectionGetter, ValueHandler elementHandler) {
        this.collectionType = collectionType;
        this.collectionSetter = collectionSetter;
        this.collectionGetter = collectionGetter;
        this.elementHandler = elementHandler;
    }

    @Override
    public void setUp(PropertyInfo propertyInfo) {
        try {
            Object container = propertyInfo.getContainer();
            Object collection = null;
            if (this.collectionGetter != null) {
                collection = this.collectionGetter.invoke(container, new Object[0]);
            }
            if (collection == null) {
                collection = this.collectionType.newInstance();
                this.collectionSetter.invoke(container, collection);
            }
            PojoInfo pojoInfo = new PojoInfo();
            pojoInfo.setVertex(propertyInfo.getSubject().getVertex());
            pojoInfo.setContext(propertyInfo.getContext());
            pojoInfo.setJavaObject(collection);
            ElementInfo elementInfo = new ElementInfo(propertyInfo);
            elementInfo.setSubject(pojoInfo);
            elementInfo.setPredicate(propertyInfo.getPredicate());
            propertyInfo.setElementInfo(elementInfo);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new KonigException(e);
        }
    }

    @Override
    public void tearDown(PropertyInfo propertyInfo) {
        propertyInfo.setElementInfo(null);
    }

    @Override
    public void handleValue(PropertyInfo propertyInfo) throws KonigException {
        ElementInfo elementInfo = propertyInfo.getElementInfo();
        elementInfo.setObject(propertyInfo.getObject());
        this.elementHandler.handleValue(elementInfo);
    }
}

