/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.pojo.impl;

import io.konig.core.KonigException;
import io.konig.core.Vertex;
import io.konig.core.pojo.PojoCreator;
import io.konig.core.pojo.impl.BasicPojoHandler;
import io.konig.core.pojo.impl.PojoInfo;
import io.konig.core.pojo.impl.PropertyInfo;
import io.konig.core.pojo.impl.ValueHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class CreatorPojoHandler
extends BasicPojoHandler {
    private Class<? extends PojoCreator<?>> creatorClass;
    private PojoCreator<?> creator;
    private Map<Class<?>, ValueHandler> elementHandlerMap;

    public CreatorPojoHandler(Class<?> javaClass, Class<? extends PojoCreator<?>> creatorClass) {
        super(javaClass);
        this.creatorClass = creatorClass;
    }

    @Override
    protected Object newInstance(PojoInfo pojoInfo) throws KonigException {
        try {
            Vertex v = pojoInfo.getVertex();
            if (this.creator == null) {
                this.creator = this.creatorClass.newInstance();
            }
            Object pojo = this.creator.create(v);
            if (v.isList()) {
                this.handleList(pojo, pojoInfo);
            }
            return pojo;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new KonigException(e);
        }
    }

    private void handleList(Object pojo, PojoInfo pojoInfo) {
        pojoInfo.setJavaObject(pojo);
        Vertex v = pojoInfo.getVertex();
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.setPredicate(RDF.FIRST);
        propertyInfo.setSubject(pojoInfo);
        ValueHandler elementHandler = this.elementHandler(pojo);
        List<Value> valueList = v.asList();
        for (Value value : valueList) {
            propertyInfo.setObject(value);
            elementHandler.handleValue(propertyInfo);
        }
    }

    private ValueHandler elementHandler(Object pojo) {
        ValueHandler handler;
        Class<?> pojoType = pojo.getClass();
        if (this.elementHandlerMap == null) {
            this.elementHandlerMap = new HashMap();
        }
        if ((handler = this.elementHandlerMap.get(pojoType)) == null) {
            Method[] methodList;
            for (Method m : methodList = pojoType.getMethods()) {
                Class<?>[] paramTypes;
                if (!m.getName().equals("add") || (paramTypes = m.getParameterTypes()).length != 1) continue;
                Type genericSuperType = pojoType.getGenericSuperclass();
                ParameterizedType pType = (ParameterizedType)genericSuperType;
                Type[] parameterArgTypes = pType.getActualTypeArguments();
                Class argType = (Class)parameterArgTypes[0];
                handler = this.valueHandler(argType, m);
                this.elementHandlerMap.put(pojoType, handler);
                break;
            }
        }
        return handler;
    }
}

