/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.pojo.impl;

import io.konig.core.KonigException;
import io.konig.core.pojo.PojoContext;
import io.konig.core.pojo.impl.BasicPojoHandler;
import io.konig.core.pojo.impl.CreatorPojoHandler;
import io.konig.core.pojo.impl.PojoHandler;
import io.konig.core.pojo.impl.PojoInfo;
import io.konig.core.pojo.impl.PojoUtil;
import org.openrdf.model.Resource;

public class MasterPojoHandler
implements PojoHandler {
    @Override
    public void buildPojo(PojoInfo pojoInfo) throws KonigException {
        Class<?> javaClass = PojoUtil.selectType(pojoInfo);
        if (javaClass != null) {
            PojoContext context = pojoInfo.getContext();
            PojoHandler delegate = context.getPojoHandler(javaClass);
            if (delegate == null) {
                delegate = this.createDelegate(javaClass);
                context.putPojoHandler(javaClass, delegate);
            }
            delegate.buildPojo(pojoInfo);
            Resource resource = pojoInfo.getVertex().getId();
            context.notify(resource, pojoInfo.getJavaObject());
        }
    }

    private PojoHandler createDelegate(Class<?> javaClass) {
        for (Class<?> type = javaClass; type != null && type != Object.class; type = type.getSuperclass()) {
            CreatorPojoHandler handler = this.creatorPojoHandler(type);
            if (handler == null) continue;
            return handler;
        }
        return new BasicPojoHandler(javaClass);
    }

    private CreatorPojoHandler creatorPojoHandler(Class<?> javaClass) {
        String packageName = javaClass.getPackage().getName();
        StringBuilder builder = new StringBuilder(packageName);
        builder.append('.');
        builder.append(javaClass.getSimpleName());
        builder.append("Creator");
        String creatorName = builder.toString();
        try {
            Class<?> creatorClass = Class.forName(creatorName);
            return new CreatorPojoHandler(javaClass, creatorClass);
        }
        catch (Throwable throwable) {
            return this.interfaceCreatorPojoHandler(javaClass);
        }
    }

    private CreatorPojoHandler interfaceCreatorPojoHandler(Class<?> javaClass) {
        Class<?>[] list;
        for (Class<?> type : list = javaClass.getInterfaces()) {
            CreatorPojoHandler handler = this.creatorPojoHandler(type);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }
}

