/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.pojo.impl;

import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.Vertex;
import io.konig.core.pojo.impl.CollectionValueHandler;
import io.konig.core.pojo.impl.ElementInfo;
import io.konig.core.pojo.impl.PropertyInfo;
import io.konig.core.pojo.impl.RdfListValueHandler;
import io.konig.core.pojo.impl.ThreePhaseValueHandler;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;

public class MultiValueHandler
implements ThreePhaseValueHandler {
    private static ElementInfo dummyInfo = new ElementInfo(null);
    private CollectionValueHandler collectionHandler;
    private RdfListValueHandler rdfListHandler;

    public MultiValueHandler(CollectionValueHandler collectionHandler, RdfListValueHandler rdfListHandler) {
        this.collectionHandler = collectionHandler;
        this.rdfListHandler = rdfListHandler;
    }

    @Override
    public void handleValue(PropertyInfo propertyInfo) throws KonigException {
        Value object = propertyInfo.getObject();
        if (object instanceof Resource) {
            Resource objectId = (Resource)object;
            Graph graph = propertyInfo.getSubject().getVertex().getGraph();
            Vertex objectVertex = graph.getVertex(objectId);
            if (objectVertex.isList()) {
                this.rdfListHandler.handleValue(propertyInfo);
            } else {
                this.useCollectionHandler(propertyInfo);
            }
        } else {
            this.useCollectionHandler(propertyInfo);
        }
    }

    private void useCollectionHandler(PropertyInfo propertyInfo) {
        if (propertyInfo.getElementInfo() == dummyInfo) {
            propertyInfo.setElementInfo(null);
            this.collectionHandler.setUp(propertyInfo);
        }
        this.collectionHandler.handleValue(propertyInfo);
    }

    @Override
    public void setUp(PropertyInfo propertyInfo) throws KonigException {
        propertyInfo.setElementInfo(dummyInfo);
    }

    @Override
    public void tearDown(PropertyInfo propertyInfo) throws KonigException {
        propertyInfo.setElementInfo(null);
    }
}

