/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.pojo.impl;

import io.konig.core.pojo.impl.LiteralPropertyHandler;
import java.lang.reflect.Method;
import java.math.BigInteger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;

public class NumberValueHandler
extends LiteralPropertyHandler {
    public NumberValueHandler(Method setter) {
        super(setter);
    }

    @Override
    protected Object javaValue(Literal literal) {
        if (literal == null) {
            return null;
        }
        String text = literal.stringValue();
        URI datatype = literal.getDatatype();
        if (XMLSchema.FLOAT.equals((Object)datatype)) {
            return new Float(text);
        }
        if (XMLSchema.DOUBLE.equals((Object)datatype) || text.indexOf(46) >= 0 || text.indexOf(101) >= 0 || text.indexOf(69) >= 0) {
            return new Double(text);
        }
        if (XMLSchema.LONG.equals((Object)datatype)) {
            return new Long(text);
        }
        if (XMLSchema.INT.equals((Object)datatype)) {
            return new Integer(text);
        }
        if (XMLSchema.SHORT.equals((Object)datatype)) {
            return new Short(text);
        }
        if (XMLSchema.BYTE.equals((Object)datatype)) {
            return new Byte(text);
        }
        try {
            long value = Long.parseLong(text);
            if (value < Integer.MAX_VALUE && value > Integer.MIN_VALUE) {
                return new Integer((int)value);
            }
            return new Long(value);
        }
        catch (Throwable ignore) {
            return new BigInteger(text);
        }
    }
}

