/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.pojo.impl;

import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.Vertex;
import io.konig.core.pojo.impl.ElementInfo;
import io.konig.core.pojo.impl.PojoInfo;
import io.konig.core.pojo.impl.PropertyInfo;
import io.konig.core.pojo.impl.ValueHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class RdfListValueHandler
implements ValueHandler {
    private Class<?> collectionType;
    private Method collectionSetter;
    private Method collectionGetter;
    private ValueHandler elementHandler;

    public RdfListValueHandler(Class<?> collectionType, Method collectionSetter, Method collectionGetter, ValueHandler elementHandler) {
        this.collectionType = collectionType;
        this.collectionSetter = collectionSetter;
        this.collectionGetter = collectionGetter;
        this.elementHandler = elementHandler;
    }

    @Override
    public void handleValue(PropertyInfo propertyInfo) throws KonigException {
        Value object = propertyInfo.getObject();
        if (object instanceof Resource) {
            Resource listId = (Resource)object;
            Graph graph = propertyInfo.getSubject().getVertex().getGraph();
            Vertex listVertex = graph.getVertex(listId);
            List<Value> valueList = listVertex.asList();
            if (valueList != null) {
                this.before(propertyInfo);
                ElementInfo elementInfo = propertyInfo.getElementInfo();
                elementInfo.getSubject().setVertex(listVertex);
                for (Value value : valueList) {
                    elementInfo.setObject(value);
                    this.elementHandler.handleValue(elementInfo);
                }
                this.after(propertyInfo);
            }
        }
    }

    public void before(PropertyInfo propertyInfo) {
        try {
            Object container = propertyInfo.getContainer();
            Object collection = null;
            if (this.collectionGetter != null) {
                collection = this.collectionGetter.invoke(container, new Object[0]);
            }
            if (collection == null) {
                collection = this.collectionType.newInstance();
                this.collectionSetter.invoke(container, collection);
            }
            PojoInfo pojoInfo = new PojoInfo();
            pojoInfo.setVertex(propertyInfo.getSubject().getVertex());
            pojoInfo.setContext(propertyInfo.getContext());
            pojoInfo.setJavaObject(collection);
            ElementInfo elementInfo = new ElementInfo(propertyInfo);
            elementInfo.setSubject(pojoInfo);
            elementInfo.setPredicate(RDF.FIRST);
            propertyInfo.setElementInfo(elementInfo);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new KonigException(e);
        }
    }

    public void after(PropertyInfo propertyInfo) {
        propertyInfo.setElementInfo(null);
    }
}

