/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.pojo.impl;

import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.Vertex;
import io.konig.core.pojo.BeanUtil;
import io.konig.core.pojo.PojoContext;
import io.konig.core.pojo.impl.PojoHandler;
import io.konig.core.pojo.impl.PojoInfo;
import io.konig.core.pojo.impl.PropertyInfo;
import io.konig.core.pojo.impl.ValueHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class ResourceHandler
implements ValueHandler {
    private Class<?> javaClass;
    private Method setter;
    private Constructor<?> stringConstructor;
    private Deserializer deserializer;

    public ResourceHandler(Class<?> javaClass, Method setter) {
        this.javaClass = javaClass;
        this.setter = setter;
    }

    @Override
    public void handleValue(PropertyInfo propertyInfo) throws KonigException {
        Object javaObject = this.javaObject(propertyInfo);
        if (javaObject != null) {
            Object container = propertyInfo.getContainer();
            try {
                this.setter.invoke(container, javaObject);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new KonigException(e);
            }
        }
    }

    private Object javaObject(PropertyInfo propertyInfo) throws KonigException {
        Object javaObject = null;
        Value object = propertyInfo.getObject();
        if (object instanceof Resource) {
            Resource objectId = (Resource)object;
            javaObject = this.javaObject(objectId, propertyInfo);
        } else {
            Constructor<?> constructor = this.stringConstructor();
            if (constructor != null && Modifier.isPublic(constructor.getModifiers())) {
                try {
                    javaObject = constructor.newInstance(object.stringValue());
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    throw new KonigException(e);
                }
            }
            if (javaObject == null) {
                Deserializer factory = this.deserializer();
                javaObject = factory.create(object.stringValue());
            }
        }
        return javaObject;
    }

    private Deserializer deserializer() throws KonigException {
        if (this.deserializer == null) {
            Class<?> factoryClass = BeanUtil.factoryClass(this.javaClass);
            Method createMethod = BeanUtil.createMethod(this.javaClass, factoryClass);
            Object factory = this.newInstance(factoryClass);
            this.deserializer = new Deserializer(factory, createMethod);
        }
        return this.deserializer;
    }

    private Object newInstance(Class<?> type) {
        if (type != null) {
            try {
                return type.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new KonigException(e);
            }
        }
        return null;
    }

    private Constructor<?> stringConstructor() {
        if (this.stringConstructor == null) {
            Constructor<?>[] ctorList;
            for (Constructor<?> ctor : ctorList = this.javaClass.getConstructors()) {
                if (ctor.getParameterTypes().length != 1 || String.class != ctor.getParameterTypes()[0]) continue;
                this.stringConstructor = ctor;
                break;
            }
        }
        return this.stringConstructor;
    }

    private Object javaObject(Resource objectId, PropertyInfo propertyInfo) {
        PojoContext context = propertyInfo.getContext();
        if (this.javaClass == Resource.class) {
            return objectId;
        }
        if (this.javaClass == URI.class) {
            return objectId instanceof URI ? objectId : null;
        }
        if (this.javaClass == BNode.class) {
            return objectId instanceof BNode ? objectId : null;
        }
        Object result = context.getIndividual(objectId);
        if (result == null) {
            Vertex subject = propertyInfo.getSubject().getVertex();
            Graph graph = subject.getGraph();
            Vertex objectVertex = graph.getVertex(objectId);
            PojoHandler pojoHandler = context.getPojoHandler();
            PojoInfo pojoInfo = new PojoInfo();
            pojoInfo.setContext(context);
            pojoInfo.setExpectedJavaClass(this.javaClass);
            pojoInfo.setVertex(objectVertex);
            pojoHandler.buildPojo(pojoInfo);
            result = pojoInfo.getJavaObject();
        }
        return result;
    }

    private static class Deserializer {
        private Object factory;
        private Method createMethod;

        public Deserializer(Object factory, Method createMethod) {
            this.factory = factory;
            this.createMethod = createMethod;
        }

        public Object create(String value) throws KonigException {
            try {
                return this.createMethod == null ? null : this.createMethod.invoke(this.factory, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new KonigException(e);
            }
        }
    }
}

